/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.identification;

import java.util.Objects;
import java.util.UUID;

public class Server
implements Comparable<Server> {
    private final UUID uuid;
    private int id;
    private String name;
    private String webAddress;
    private int maxPlayers;

    public Server(int id, UUID uuid, String name, String webAddress, int maxPlayers) {
        this.id = id;
        this.uuid = uuid;
        this.name = name;
        this.webAddress = webAddress;
        this.maxPlayers = maxPlayers;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public String getName() {
        return this.name;
    }

    public String getIdentifiableName() {
        return !"Plan".equalsIgnoreCase(this.name) ? this.name : "Server " + this.id;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getWebAddress() {
        return this.webAddress;
    }

    public void setWebAddress(String webAddress) {
        this.webAddress = webAddress;
    }

    public int getMaxPlayers() {
        return this.maxPlayers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Server that = (Server)o;
        return Objects.equals(this.uuid, that.uuid) && Objects.equals(this.name, that.name) && Objects.equals(this.webAddress, that.webAddress);
    }

    public int hashCode() {
        return Objects.hash(this.uuid, this.id, this.name, this.webAddress);
    }

    public String toString() {
        return "Server{uuid=" + this.uuid + ", id=" + this.id + ", name='" + this.name + '\'' + ", webAddress='" + this.webAddress + '\'' + ", maxPlayers=" + this.maxPlayers + '}';
    }

    @Override
    public int compareTo(Server other) {
        return Integer.compare(this.id, other.id);
    }

    public boolean isProxy() {
        return "BungeeCord".equals(this.name);
    }

    public boolean isNotProxy() {
        return !this.isProxy();
    }

    public void setMaxPlayers(int maxPlayers) {
        this.maxPlayers = maxPlayers;
    }
}

