/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.identification;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.properties.ServerProperties;
import com.djrapitops.plugin.utilities.Verify;
import java.util.Optional;
import java.util.UUID;

public abstract class ServerInfo
implements SubSystem {
    protected Server server;
    protected final ServerProperties serverProperties;

    public ServerInfo(ServerProperties serverProperties) {
        this.serverProperties = serverProperties;
    }

    public Server getServer() {
        return this.server;
    }

    public UUID getServerUUID() {
        return this.getServer().getUuid();
    }

    public Optional<UUID> getServerUUIDSafe() {
        return Optional.ofNullable(this.server).map(Server::getUuid);
    }

    public ServerProperties getServerProperties() {
        return this.serverProperties;
    }

    @Override
    public void enable() throws EnableException {
        this.loadServerInfo();
        Verify.nullCheck(this.server, () -> new EnableException("Server information did not load!"));
    }

    protected abstract void loadServerInfo() throws EnableException;

    @Override
    public void disable() {
    }

    protected UUID generateNewUUID() {
        return UUID.randomUUID();
    }
}

