/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.identification;

import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ConfigReader;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plugin.utilities.Verify;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;

public class ServerInfoFile
extends Config {
    private final PlanFiles files;

    @Inject
    public ServerInfoFile(PlanFiles files) {
        super(files.getFileFromPluginFolder("ServerInfoFile.yml"));
        this.files = files;
    }

    public void prepare() throws IOException {
        try (ConfigReader reader = new ConfigReader(this.files.getResourceFromJar("DefaultServerInfoFile.yml").asInputStream());){
            this.copyMissing(reader.read());
        }
        this.save();
    }

    public void saveServerUUID(UUID serverUUID) throws IOException {
        this.set("Server.UUID", serverUUID.toString());
        this.save();
    }

    public Optional<UUID> getUUID() {
        String uuidString = this.getString("Server.UUID");
        if (Verify.isEmpty(uuidString)) {
            return Optional.empty();
        }
        return Optional.of(UUID.fromString(uuidString));
    }
}

