/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.identification;

import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.identification.ServerInfoFile;
import com.djrapitops.plan.identification.properties.ServerProperties;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.transactions.StoreServerInformationTransaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ServerServerInfo
extends ServerInfo {
    private final ServerInfoFile serverInfoFile;
    private final PlanConfig config;
    private final Processing processing;
    private final DBSystem dbSystem;
    private final Addresses addresses;
    private final ErrorLogger errorLogger;

    @Inject
    public ServerServerInfo(ServerProperties serverProperties, ServerInfoFile serverInfoFile, Processing processing, PlanConfig config, DBSystem dbSystem, Addresses addresses, ErrorLogger errorLogger) {
        super(serverProperties);
        this.serverInfoFile = serverInfoFile;
        this.processing = processing;
        this.dbSystem = dbSystem;
        this.addresses = addresses;
        this.config = config;
        this.errorLogger = errorLogger;
    }

    @Override
    public void enable() throws EnableException {
        try {
            this.serverInfoFile.prepare();
        }
        catch (IOException e) {
            throw new EnableException("Failed to read ServerInfoFile.yml", e);
        }
        super.enable();
    }

    @Override
    protected void loadServerInfo() throws EnableException {
        Optional<UUID> serverUUID = this.serverInfoFile.getUUID();
        try {
            if (serverUUID.isPresent()) {
                this.server = this.createServerObject(serverUUID.get());
                this.processing.submitNonCritical(() -> this.updateDbInfo((UUID)serverUUID.get()));
            } else {
                this.server = this.registerServer();
            }
        }
        catch (DBOpException e) {
            String causeMsg = e.getMessage();
            throw new EnableException("Failed to read Server information from Database: " + causeMsg, e);
        }
        catch (IOException e) {
            throw new EnableException("Failed to read ServerInfoFile.yml", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            throw new EnableException("Failed to perform a database transaction to store the server information", e);
        }
    }

    private void updateDbInfo(UUID serverUUID) {
        Database db = this.dbSystem.getDatabase();
        Optional<Server> foundServer = db.query(ServerQueries.fetchServerMatchingIdentifier(serverUUID));
        if (!foundServer.isPresent()) {
            try {
                this.server = this.registerServer(serverUUID);
            }
            catch (IOException e) {
                this.errorLogger.log(L.CRITICAL, e, ErrorContext.builder().whatToDo("Grant access permissions for writing to " + this.serverInfoFile.getConfigFilePath()).build());
            }
            catch (ExecutionException e) {
                this.errorLogger.log(L.CRITICAL, e, ErrorContext.builder().build());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            return;
        }
        this.server = foundServer.get();
        String name = this.config.get(PluginSettings.SERVER_NAME);
        this.server.setName("plan".equalsIgnoreCase(name) ? "Server " + this.server.getId() : name);
        this.addresses.getAccessAddress().ifPresent(this.server::setWebAddress);
        int maxPlayers = this.serverProperties.getMaxPlayers();
        this.server.setMaxPlayers(maxPlayers);
        db.executeTransaction(new StoreServerInformationTransaction(this.server));
    }

    private Server registerServer() throws ExecutionException, InterruptedException, IOException {
        return this.registerServer(this.generateNewUUID());
    }

    private Server registerServer(UUID serverUUID) throws ExecutionException, InterruptedException, IOException {
        Database db = this.dbSystem.getDatabase();
        Server server = this.createServerObject(serverUUID);
        db.executeTransaction(new StoreServerInformationTransaction(server)).get();
        server = db.query(ServerQueries.fetchServerMatchingIdentifier(serverUUID)).orElseThrow(() -> new IllegalStateException("Failed to Register Server (ID not found)"));
        this.serverInfoFile.saveServerUUID(serverUUID);
        return server;
    }

    private Server createServerObject(UUID serverUUID) {
        String webAddress = this.addresses.getAccessAddress().orElse(this.addresses.getFallbackLocalhostAddress());
        String name = this.config.get(PluginSettings.SERVER_NAME);
        int maxPlayers = this.serverProperties.getMaxPlayers();
        return new Server(-1, serverUUID, name, webAddress, maxPlayers);
    }
}

