/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.identification;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.UserIdentifierQueries;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.api.utility.UUIDFetcher;
import com.djrapitops.plugin.logging.L;
import java.util.Optional;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class UUIDUtility {
    private final DBSystem dbSystem;
    private final ErrorLogger errorLogger;

    @Inject
    public UUIDUtility(DBSystem dbSystem, ErrorLogger errorLogger) {
        this.dbSystem = dbSystem;
        this.errorLogger = errorLogger;
    }

    public static Optional<UUID> parseFromString(String uuidString) {
        try {
            return Optional.of(UUID.fromString(uuidString));
        }
        catch (IllegalArgumentException malformedUUIDException) {
            return Optional.empty();
        }
    }

    public UUID getUUIDOf(String playerName) {
        if (playerName == null) {
            throw new IllegalArgumentException("Player name can not be null!");
        }
        UUID uuid = this.getUUIDFromString(playerName);
        if (uuid != null) {
            return uuid;
        }
        return this.getUUIDFromDB(playerName).orElse(this.getUUIDViaUUIDFetcher(playerName));
    }

    private UUID getUUIDFromString(String playerName) {
        try {
            return UUID.fromString(playerName);
        }
        catch (IllegalArgumentException ignore) {
            return null;
        }
    }

    private UUID getUUIDViaUUIDFetcher(String playerName) {
        try {
            return UUIDFetcher.getUUIDOf(playerName);
        }
        catch (Exception | NoClassDefFoundError ignored) {
            return null;
        }
    }

    private Optional<UUID> getUUIDFromDB(String playerName) {
        try {
            return this.dbSystem.getDatabase().query(UserIdentifierQueries.fetchPlayerUUIDOf(playerName));
        }
        catch (DBOpException e) {
            this.errorLogger.log(L.ERROR, e);
            return Optional.empty();
        }
    }
}

