/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.identification;

import com.djrapitops.plan.delivery.webserver.Addresses;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.identification.properties.ServerProperties;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.transactions.StoreServerInformationTransaction;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class VelocityServerInfo
extends ServerInfo {
    private final DBSystem dbSystem;
    private final Addresses addresses;
    private final PluginLogger logger;

    @Inject
    public VelocityServerInfo(ServerProperties serverProperties, DBSystem dbSystem, Addresses addresses, PluginLogger logger) {
        super(serverProperties);
        this.dbSystem = dbSystem;
        this.addresses = addresses;
        this.logger = logger;
    }

    @Override
    public void loadServerInfo() throws EnableException {
        this.checkIfDefaultIP();
        try {
            Database database = this.dbSystem.getDatabase();
            Optional<Server> proxyInfo = database.query(ServerQueries.fetchProxyServerInformation());
            if (proxyInfo.isPresent()) {
                this.server = proxyInfo.get();
                this.updateServerInfo();
            } else {
                this.server = this.registerVelocityInfo(database);
            }
        }
        catch (DBOpException | ExecutionException e) {
            throw new EnableException("Failed to read Server information from Database.");
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void updateServerInfo() {
        this.addresses.getAccessAddress().ifPresent(this::saveAddress);
    }

    private void saveAddress(String accessAddress) {
        if (!accessAddress.equals(this.server.getWebAddress())) {
            this.server.setWebAddress(accessAddress);
            this.dbSystem.getDatabase().executeTransaction(new StoreServerInformationTransaction(this.server));
        }
    }

    private void checkIfDefaultIP() throws EnableException {
        String ip = this.serverProperties.getIp();
        if ("0.0.0.0".equals(ip)) {
            this.logger.error("IP setting still 0.0.0.0 - Configure Alternative_IP/IP that connects to the Proxy server.");
            this.logger.info("Player Analytics partially enabled (Use /planbungee to reload config)");
            throw new EnableException("IP setting still 0.0.0.0 - Configure Alternative_IP/IP that connects to the Proxy server.");
        }
    }

    private Server registerVelocityInfo(Database db) throws EnableException, ExecutionException, InterruptedException {
        UUID serverUUID = this.generateNewUUID();
        String accessAddress = this.addresses.getAccessAddress().orElseThrow(() -> new EnableException("Velocity can not have '0.0.0.0' or '' as an address. Set up 'Server.IP' setting."));
        Server proxy = new Server(-1, serverUUID, "BungeeCord", accessAddress, this.serverProperties.getMaxPlayers());
        db.executeTransaction(new StoreServerInformationTransaction(proxy)).get();
        Optional<Server> proxyInfo = db.query(ServerQueries.fetchProxyServerInformation());
        if (proxyInfo.isPresent()) {
            return proxyInfo.get();
        }
        throw new EnableException("Velocity registration failed (DB)");
    }
}

