/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.placeholder;

import com.djrapitops.plan.delivery.domain.container.PlayerContainer;
import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.placeholder.Placeholders;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.containers.ContainerFetchQueries;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public final class PlanPlaceholders {
    private final Map<String, PlayerPlaceholderLoader> playerPlaceholders;
    private final Map<String, StaticPlaceholderLoader> staticPlaceholders;
    private final Map<String, BiFunction<String, PlayerContainer, Serializable>> rawHandlers;
    private final DBSystem dbSystem;

    @Inject
    public PlanPlaceholders(PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, Formatters formatters, Set<Placeholders> placeholderRegistries) {
        this.dbSystem = dbSystem;
        this.playerPlaceholders = new HashMap<String, PlayerPlaceholderLoader>();
        this.staticPlaceholders = new HashMap<String, StaticPlaceholderLoader>();
        this.rawHandlers = new HashMap<String, BiFunction<String, PlayerContainer, Serializable>>();
        for (Placeholders registry : placeholderRegistries) {
            registry.register(this);
        }
    }

    public void registerStatic(String name, Supplier<Serializable> loader) {
        this.registerStatic(name, params -> (Serializable)loader.get());
    }

    public void registerStatic(String name, StaticPlaceholderLoader loader) {
        this.staticPlaceholders.put(name, loader);
    }

    public void register(String name, Function<PlayerContainer, Serializable> loader) {
        this.register(name, (player, params) -> (Serializable)loader.apply((PlayerContainer)player));
    }

    public void register(String name, PlayerPlaceholderLoader loader) {
        this.playerPlaceholders.put(name, loader);
    }

    public void registerRaw(String name, BiFunction<String, PlayerContainer, Serializable> loader) {
        this.rawHandlers.put(name, loader);
    }

    public Map<String, PlayerPlaceholderLoader> getPlaceholders() {
        return this.playerPlaceholders;
    }

    public Map<String, StaticPlaceholderLoader> getStaticPlaceholders() {
        return this.staticPlaceholders;
    }

    public String onPlaceholderRequest(UUID uuid, String placeholder, List<String> parameters) {
        PlayerContainer player;
        if (uuid != null) {
            player = this.dbSystem.getDatabase().query(ContainerFetchQueries.fetchPlayerContainer(uuid));
            SessionCache.getCachedSession(uuid).ifPresent(session -> player.putRawData(PlayerKeys.ACTIVE_SESSION, session));
        } else {
            player = null;
        }
        return this.onPlaceholderRequest(player, placeholder, parameters);
    }

    public String onPlaceholderRequest(PlayerContainer player, String placeholder, List<String> parameters) {
        for (Map.Entry<String, BiFunction<String, PlayerContainer, Serializable>> entry : this.rawHandlers.entrySet()) {
            if (!placeholder.startsWith(entry.getKey())) continue;
            return Objects.toString(entry.getValue().apply(placeholder, player));
        }
        StaticPlaceholderLoader staticLoader = this.staticPlaceholders.get(placeholder);
        if (staticLoader != null) {
            return Objects.toString(staticLoader.apply(parameters));
        }
        PlayerPlaceholderLoader loader = this.playerPlaceholders.get(placeholder);
        if (loader != null && player != null) {
            return Objects.toString(loader.apply(player, parameters));
        }
        return null;
    }

    public static interface StaticPlaceholderLoader
    extends Function<List<String>, Serializable> {
    }

    public static interface PlayerPlaceholderLoader
    extends BiFunction<PlayerContainer, List<String>, Serializable> {
    }
}

