/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.placeholder;

import com.djrapitops.plan.delivery.domain.keys.PlayerKeys;
import com.djrapitops.plan.delivery.domain.mutators.PerServerMutator;
import com.djrapitops.plan.delivery.domain.mutators.PingMutator;
import com.djrapitops.plan.delivery.domain.mutators.PlayerVersusMutator;
import com.djrapitops.plan.delivery.domain.mutators.SessionsMutator;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.identification.Server;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.placeholder.Placeholders;
import com.djrapitops.plan.placeholder.PlanPlaceholders;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.utilities.MiscUtils;
import com.djrapitops.plan.utilities.Predicates;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlayerPlaceHolders
implements Placeholders {
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Formatters formatters;

    @Inject
    public PlayerPlaceHolders(DBSystem dbSystem, ServerInfo serverInfo, Formatters formatters) {
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.formatters = formatters;
    }

    @Override
    public void register(PlanPlaceholders placeholders) {
        Formatter<Double> decimals = this.formatters.decimals();
        Formatter<Long> year = this.formatters.yearLong();
        Formatter<Long> time = this.formatters.timeAmount();
        placeholders.register("player_banned", player -> player.getValue(PlayerKeys.BANNED).orElse(Boolean.FALSE));
        placeholders.register("player_operator", player -> player.getValue(PlayerKeys.OPERATOR).orElse(Boolean.FALSE));
        placeholders.register("player_sessions_count", player -> Integer.valueOf(SessionsMutator.forContainer(player).count()));
        placeholders.register("player_kick_count", player -> player.getValue(PlayerKeys.KICK_COUNT).orElse(0));
        placeholders.register("player_death_count", player -> player.getValue(PlayerKeys.DEATH_COUNT).orElse(0));
        placeholders.register("player_mob_kill_count", player -> player.getValue(PlayerKeys.MOB_KILL_COUNT).orElse(0));
        placeholders.register("player_player_kill_count", player -> player.getValue(PlayerKeys.PLAYER_KILL_COUNT).orElse(0));
        placeholders.register("player_kill_death_ratio", player -> Double.valueOf(PlayerVersusMutator.forContainer(player).toKillDeathRatio()));
        placeholders.register("player_ping_average_day", player -> (String)decimals.apply(PingMutator.forContainer(player).filterBy(Predicates.within(MiscUtils.dayAgo(), MiscUtils.now())).average()) + " ms");
        placeholders.register("player_ping_average_week", player -> (String)decimals.apply(PingMutator.forContainer(player).filterBy(Predicates.within(MiscUtils.weekAgo(), MiscUtils.now())).average()) + " ms");
        placeholders.register("player_ping_average_month", player -> (String)decimals.apply(PingMutator.forContainer(player).filterBy(Predicates.within(MiscUtils.monthAgo(), MiscUtils.now())).average()) + " ms");
        placeholders.register("player_lastseen", player -> (String)year.apply(player.getValue(PlayerKeys.LAST_SEEN).orElse(0L)));
        placeholders.register("player_registered", player -> (String)year.apply(player.getValue(PlayerKeys.REGISTERED).orElse(0L)));
        placeholders.register("player_time_active", player -> (String)time.apply(SessionsMutator.forContainer(player).toActivePlaytime()));
        placeholders.register("player_time_afk", player -> (String)time.apply(SessionsMutator.forContainer(player).toAfkTime()));
        placeholders.register("player_time_total", player -> (String)time.apply(SessionsMutator.forContainer(player).toPlaytime()));
        placeholders.register("player_time_day", player -> (String)time.apply(SessionsMutator.forContainer(player).filterSessionsBetween(MiscUtils.dayAgo(), MiscUtils.now()).toPlaytime()));
        placeholders.register("player_time_week", player -> (String)time.apply(SessionsMutator.forContainer(player).filterSessionsBetween(MiscUtils.weekAgo(), MiscUtils.now()).toPlaytime()));
        placeholders.register("player_time_month", player -> (String)time.apply(SessionsMutator.forContainer(player).filterSessionsBetween(MiscUtils.monthAgo(), MiscUtils.now()).toPlaytime()));
        placeholders.register("player_server_time_active", player -> (String)time.apply(SessionsMutator.forContainer(player).filterPlayedOnServer(this.serverInfo.getServerUUID()).toActivePlaytime()));
        placeholders.register("player_server_time_afk", player -> (String)time.apply(SessionsMutator.forContainer(player).filterPlayedOnServer(this.serverInfo.getServerUUID()).toAfkTime()));
        placeholders.register("player_server_time_total", player -> (String)time.apply(SessionsMutator.forContainer(player).filterPlayedOnServer(this.serverInfo.getServerUUID()).toPlaytime()));
        placeholders.register("player_server_time_day", player -> (String)time.apply(SessionsMutator.forContainer(player).filterSessionsBetween(MiscUtils.dayAgo(), MiscUtils.now()).filterPlayedOnServer(this.serverInfo.getServerUUID()).toPlaytime()));
        placeholders.register("player_server_time_week", player -> (String)time.apply(SessionsMutator.forContainer(player).filterSessionsBetween(MiscUtils.weekAgo(), MiscUtils.now()).filterPlayedOnServer(this.serverInfo.getServerUUID()).toPlaytime()));
        placeholders.register("player_server_time_month", player -> (String)time.apply(SessionsMutator.forContainer(player).filterSessionsBetween(MiscUtils.monthAgo(), MiscUtils.now()).filterPlayedOnServer(this.serverInfo.getServerUUID()).toPlaytime()));
        placeholders.register("player_favorite_server", player -> PerServerMutator.forContainer(player).favoriteServer().flatMap(serverUUID -> this.dbSystem.getDatabase().query(ServerQueries.fetchServerMatchingIdentifier(serverUUID))).map(Server::getName).orElse("-"));
    }
}

