/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.placeholder;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.placeholder.Placeholders;
import com.djrapitops.plan.placeholder.PlanPlaceholders;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import com.djrapitops.plan.utilities.MiscUtils;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ServerPlaceHolders
implements Placeholders {
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Formatters formatters;

    @Inject
    public ServerPlaceHolders(DBSystem dbSystem, ServerInfo serverInfo, Formatters formatters) {
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.formatters = formatters;
    }

    @Override
    public void register(PlanPlaceholders placeholders) {
        Formatter<Double> decimals = this.formatters.decimals();
        Formatter<Double> percentage = this.formatters.percentage();
        Database database = this.dbSystem.getDatabase();
        UUID serverUUID = this.serverInfo.getServerUUID();
        placeholders.registerStatic("server_tps_day", () -> (String)decimals.apply(database.query(TPSQueries.averageTPS(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("server_tps_week", () -> (String)decimals.apply(database.query(TPSQueries.averageTPS(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("server_tps_month", () -> (String)decimals.apply(database.query(TPSQueries.averageTPS(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("server_cpu_day", () -> (String)percentage.apply(database.query(TPSQueries.averageCPU(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("server_cpu_week", () -> (String)percentage.apply(database.query(TPSQueries.averageCPU(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("server_cpu_month", () -> (String)percentage.apply(database.query(TPSQueries.averageCPU(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("server_ram_day", () -> database.query(TPSQueries.averageRAM(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)) + " MB");
        placeholders.registerStatic("server_ram_week", () -> database.query(TPSQueries.averageRAM(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)) + " MB");
        placeholders.registerStatic("server_ram_month", () -> database.query(TPSQueries.averageRAM(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)) + " MB");
        placeholders.registerStatic("server_chunks_day", () -> database.query(TPSQueries.averageChunks(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_chunks_week", () -> database.query(TPSQueries.averageChunks(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_chunks_month", () -> database.query(TPSQueries.averageChunks(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_entities_day", () -> database.query(TPSQueries.averageEntities(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_entities_week", () -> database.query(TPSQueries.averageEntities(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_entities_month", () -> database.query(TPSQueries.averageEntities(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_max_free_disk_day", () -> database.query(TPSQueries.maxFreeDisk(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_max_free_disk_week", () -> database.query(TPSQueries.maxFreeDisk(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_max_free_disk_month", () -> database.query(TPSQueries.maxFreeDisk(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_min_free_disk_day", () -> database.query(TPSQueries.minFreeDisk(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_min_free_disk_week", () -> database.query(TPSQueries.minFreeDisk(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_min_free_disk_month", () -> database.query(TPSQueries.minFreeDisk(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_average_free_disk_day", () -> database.query(TPSQueries.averageFreeDisk(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_average_free_disk_week", () -> database.query(TPSQueries.averageFreeDisk(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_average_free_disk_month", () -> database.query(TPSQueries.averageFreeDisk(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("server_name", () -> this.serverInfo.getServer().getName());
        placeholders.registerStatic("server_uuid", this.serverInfo::getServerUUID);
    }
}

