/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.placeholder;

import com.djrapitops.plan.delivery.domain.DateHolder;
import com.djrapitops.plan.delivery.domain.DateObj;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.placeholder.Placeholders;
import com.djrapitops.plan.placeholder.PlanPlaceholders;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.analysis.PlayerCountQueries;
import com.djrapitops.plan.storage.database.queries.objects.KillQueries;
import com.djrapitops.plan.storage.database.queries.objects.PingQueries;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.TPSQueries;
import com.djrapitops.plan.utilities.MiscUtils;
import java.io.Serializable;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class SessionPlaceHolders
implements Placeholders {
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Formatters formatters;

    @Inject
    public SessionPlaceHolders(PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, Formatters formatters) {
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.formatters = formatters;
    }

    @Override
    public void register(PlanPlaceholders placeholders) {
        int tzOffsetMs = this.config.getTimeZone().getOffset(System.currentTimeMillis());
        Formatter<Long> timeAmount = this.formatters.timeAmount();
        Formatter<DateHolder> year = this.formatters.year();
        Formatter<Double> decimals = this.formatters.decimals();
        Database database = this.dbSystem.getDatabase();
        UUID serverUUID = this.serverInfo.getServerUUID();
        placeholders.registerStatic("sessions_play_time_total", () -> (String)timeAmount.apply(database.query(SessionQueries.playtime(0L, MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_play_time_day", () -> (String)timeAmount.apply(database.query(SessionQueries.playtime(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_play_time_week", () -> (String)timeAmount.apply(database.query(SessionQueries.playtime(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_play_time_month", () -> (String)timeAmount.apply(database.query(SessionQueries.playtime(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_active_time_total", () -> (String)timeAmount.apply(database.query(SessionQueries.activePlaytime(0L, MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_active_time_day", () -> (String)timeAmount.apply(database.query(SessionQueries.activePlaytime(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_active_time_week", () -> (String)timeAmount.apply(database.query(SessionQueries.activePlaytime(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_active_time_month", () -> (String)timeAmount.apply(database.query(SessionQueries.activePlaytime(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_afk_time_total", () -> (String)timeAmount.apply(database.query(SessionQueries.afkTime(0L, MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_afk_time_day", () -> (String)timeAmount.apply(database.query(SessionQueries.afkTime(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_afk_time_week", () -> (String)timeAmount.apply(database.query(SessionQueries.afkTime(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID))));
        placeholders.registerStatic("sessions_afk_time_month", () -> (String)timeAmount.apply(database.query(SessionQueries.afkTime(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID))));
        Supplier<Serializable> uniquePlayers = () -> database.query(PlayerCountQueries.newPlayerCount(0L, MiscUtils.now(), serverUUID));
        placeholders.registerStatic("sessions_unique_players_total", uniquePlayers);
        placeholders.registerStatic("sessions_new_players_total", uniquePlayers);
        placeholders.registerStatic("sessions_unique_players_day", () -> database.query(PlayerCountQueries.uniquePlayerCount(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_unique_players_today", () -> database.query(PlayerCountQueries.uniquePlayerCounts(MiscUtils.dayAgo(), MiscUtils.now(), this.config.getTimeZone().getOffset(MiscUtils.now()), serverUUID)).lastEntry().getValue());
        placeholders.registerStatic("sessions_unique_players_week", () -> database.query(PlayerCountQueries.uniquePlayerCount(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_unique_players_month", () -> database.query(PlayerCountQueries.uniquePlayerCount(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_players_death_total", () -> database.query(KillQueries.deathCount(0L, MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_players_death_day", () -> database.query(KillQueries.deathCount(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_players_death_week", () -> database.query(KillQueries.deathCount(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_players_death_month", () -> database.query(KillQueries.deathCount(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_players_kill_total", () -> database.query(KillQueries.playerKillCount(0L, MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_players_kill_day", () -> database.query(KillQueries.playerKillCount(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_players_kill_week", () -> database.query(KillQueries.playerKillCount(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_players_kill_month", () -> database.query(KillQueries.playerKillCount(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_mob_kill_total", () -> database.query(KillQueries.mobKillCount(0L, MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_mob_kill_day", () -> database.query(KillQueries.mobKillCount(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_mob_kill_week", () -> database.query(KillQueries.mobKillCount(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_mob_kill_month", () -> database.query(KillQueries.mobKillCount(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_average_session_length_total", () -> SessionPlaceHolders.getPlaytime(database, 0L, MiscUtils.now(), serverUUID, timeAmount));
        placeholders.registerStatic("sessions_average_session_length_day", () -> SessionPlaceHolders.getPlaytime(database, MiscUtils.dayAgo(), MiscUtils.now(), serverUUID, timeAmount));
        placeholders.registerStatic("sessions_average_session_length_week", () -> SessionPlaceHolders.getPlaytime(database, MiscUtils.weekAgo(), MiscUtils.now(), serverUUID, timeAmount));
        placeholders.registerStatic("sessions_average_session_length_month", () -> SessionPlaceHolders.getPlaytime(database, MiscUtils.monthAgo(), MiscUtils.now(), serverUUID, timeAmount));
        placeholders.registerStatic("sessions_average_unique_players_total", () -> database.query(PlayerCountQueries.averageUniquePlayerCount(0L, MiscUtils.now(), tzOffsetMs, serverUUID)));
        placeholders.registerStatic("sessions_average_unique_players_day", () -> database.query(PlayerCountQueries.averageUniquePlayerCount(MiscUtils.dayAgo(), MiscUtils.now(), tzOffsetMs, serverUUID)));
        placeholders.registerStatic("sessions_average_unique_players_week", () -> database.query(PlayerCountQueries.averageUniquePlayerCount(MiscUtils.weekAgo(), MiscUtils.now(), tzOffsetMs, serverUUID)));
        placeholders.registerStatic("sessions_average_unique_players_month", () -> database.query(PlayerCountQueries.averageUniquePlayerCount(MiscUtils.monthAgo(), MiscUtils.now(), tzOffsetMs, serverUUID)));
        placeholders.registerStatic("sessions_new_players_day", () -> database.query(PlayerCountQueries.newPlayerCount(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_new_players_week", () -> database.query(PlayerCountQueries.newPlayerCount(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("sessions_new_players_month", () -> database.query(PlayerCountQueries.newPlayerCount(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID)));
        placeholders.registerStatic("ping_total", () -> (String)decimals.apply(database.query(PingQueries.averagePing(0L, MiscUtils.now(), serverUUID))) + " ms");
        placeholders.registerStatic("ping_day", () -> (String)decimals.apply(database.query(PingQueries.averagePing(MiscUtils.dayAgo(), MiscUtils.now(), serverUUID))) + " ms");
        placeholders.registerStatic("ping_week", () -> (String)decimals.apply(database.query(PingQueries.averagePing(MiscUtils.weekAgo(), MiscUtils.now(), serverUUID))) + " ms");
        placeholders.registerStatic("ping_month", () -> (String)decimals.apply(database.query(PingQueries.averagePing(MiscUtils.monthAgo(), MiscUtils.now(), serverUUID))) + " ms");
        placeholders.registerStatic("sessions_peak_count", () -> database.query(TPSQueries.fetchAllTimePeakPlayerCount(serverUUID)).map(DateObj::getValue).orElse(0));
        placeholders.registerStatic("sessions_peak_date", () -> database.query(TPSQueries.fetchAllTimePeakPlayerCount(serverUUID)).map(year).orElse("-"));
        placeholders.registerStatic("sessions_recent_peak_count", () -> database.query(TPSQueries.fetchPeakPlayerCount(serverUUID, MiscUtils.now() - TimeUnit.DAYS.toMillis(2L))).map(DateObj::getValue).orElse(0));
        placeholders.registerStatic("sessions_recent_peak_date", () -> database.query(TPSQueries.fetchPeakPlayerCount(serverUUID, MiscUtils.now() - TimeUnit.DAYS.toMillis(2L))).map(year).orElse("-"));
    }

    private static String getPlaytime(Database database, long after, long before, UUID serverUUID, Formatter<Long> timeAmount) {
        Long playtime = database.query(SessionQueries.playtime(after, before, serverUUID));
        Long sessionCount = database.query(SessionQueries.sessionCount(after, before, serverUUID));
        return (String)timeAmount.apply(sessionCount != 0L ? playtime / sessionCount : playtime);
    }
}

