/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.placeholder;

import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.placeholder.Placeholders;
import com.djrapitops.plan.placeholder.PlanPlaceholders;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.queries.objects.WorldTimesQueries;
import java.io.Serializable;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class WorldTimePlaceHolders
implements Placeholders {
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final Formatters formatters;

    @Inject
    public WorldTimePlaceHolders(DBSystem dbSystem, ServerInfo serverInfo, Formatters formatters) {
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.formatters = formatters;
    }

    @Override
    public void register(PlanPlaceholders placeholders) {
        Formatter<Long> timeAmount = this.formatters.timeAmount();
        placeholders.registerRaw("worlds_playtime_total_", (input, p) -> {
            String worldName = input.substring("worlds_playtime_total_".length());
            WorldTimes worldTimes = this.dbSystem.getDatabase().query(WorldTimesQueries.fetchServerTotalWorldTimes(this.serverInfo.getServerUUID()));
            return (Serializable)timeAmount.apply(worldTimes.getWorldPlaytime(worldName));
        });
        placeholders.registerStatic("worlds_playtime_total", params -> {
            if (params.isEmpty()) {
                return null;
            }
            String worldName = (String)params.get(0);
            WorldTimes worldTimes = this.dbSystem.getDatabase().query(WorldTimesQueries.fetchServerTotalWorldTimes(this.serverInfo.getServerUUID()));
            return (Serializable)timeAmount.apply(worldTimes.getWorldPlaytime(worldName));
        });
    }
}

