/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.processing;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.processing.CriticalCallable;
import com.djrapitops.plan.processing.CriticalRunnable;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.concurrent.BasicThreadFactory;

@Singleton
public class Processing
implements SubSystem {
    private final Lazy<Locale> locale;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private ExecutorService nonCriticalExecutor;
    private ExecutorService criticalExecutor;

    @Inject
    public Processing(Lazy<Locale> locale, PluginLogger logger, ErrorLogger errorLogger) {
        this.locale = locale;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.nonCriticalExecutor = this.createExecutor(6, "Plan Non critical-pool-%d");
        this.criticalExecutor = this.createExecutor(2, "Plan Critical-pool-%d");
    }

    protected ExecutorService createExecutor(int i, String s) {
        return Executors.newFixedThreadPool(i, new BasicThreadFactory.Builder().namingPattern(s).uncaughtExceptionHandler((thread, throwable) -> this.errorLogger.log(L.WARN, throwable, ErrorContext.builder().build())).build());
    }

    public void submit(Runnable runnable) {
        if (runnable instanceof CriticalRunnable) {
            this.submitCritical(runnable);
            return;
        }
        this.submitNonCritical(runnable);
    }

    public void submitNonCritical(Runnable runnable) {
        if (runnable == null || this.nonCriticalExecutor.isShutdown()) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            runnable.run();
            return true;
        }, this.nonCriticalExecutor).handle(this::exceptionHandlerNonCritical);
    }

    public void submitCritical(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        CompletableFuture.supplyAsync(() -> {
            runnable.run();
            return true;
        }, this.criticalExecutor).handle(this::exceptionHandlerCritical);
    }

    public <T> Future<T> submit(Callable<T> task) {
        if (task instanceof CriticalCallable) {
            return this.submitCritical(task);
        }
        return this.submitNonCritical(task);
    }

    public <T> Future<T> submitNonCritical(Callable<T> task) {
        if (task == null || this.nonCriticalExecutor.isShutdown()) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return task.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }, this.nonCriticalExecutor).handle(this::exceptionHandlerNonCritical);
    }

    private <T> T exceptionHandlerNonCritical(T t, Throwable throwable) {
        if (throwable != null) {
            this.errorLogger.log(L.WARN, throwable.getCause(), ErrorContext.builder().build());
        }
        return t;
    }

    private <T> T exceptionHandlerCritical(T t, Throwable throwable) {
        if (throwable != null) {
            this.errorLogger.log(L.ERROR, throwable.getCause(), ErrorContext.builder().build());
        }
        return t;
    }

    public <T> Future<T> submitCritical(Callable<T> task) {
        if (task == null) {
            return null;
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return task.call();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }, this.criticalExecutor).handle(this::exceptionHandlerCritical);
    }

    @Override
    public void enable() {
        if (this.nonCriticalExecutor.isShutdown()) {
            this.nonCriticalExecutor = this.createExecutor(6, "Plan Non critical-pool-%d");
        }
        if (this.criticalExecutor.isShutdown()) {
            this.criticalExecutor = this.createExecutor(2, "Plan Critical-pool-%d");
        }
    }

    @Override
    public void disable() {
        this.shutdownNonCriticalExecutor();
        this.shutdownCriticalExecutor();
        this.ensureShutdown();
        this.logger.info(this.locale.get().getString(PluginLang.DISABLED_PROCESSING_COMPLETE));
    }

    private void shutdownNonCriticalExecutor() {
        this.nonCriticalExecutor.shutdown();
    }

    private void shutdownCriticalExecutor() {
        List<Runnable> criticalTasks = this.criticalExecutor.shutdownNow();
        this.logger.info(this.locale.get().getString(PluginLang.DISABLED_PROCESSING, Integer.valueOf(criticalTasks.size())));
        for (Runnable runnable : criticalTasks) {
            if (runnable == null) continue;
            try {
                runnable.run();
            }
            catch (Exception | NoClassDefFoundError | NoSuchFieldError | NoSuchMethodError e) {
                this.errorLogger.log(L.WARN, e, ErrorContext.builder().build());
            }
        }
    }

    private void ensureShutdown() {
        try {
            if (!this.nonCriticalExecutor.isTerminated() && !this.nonCriticalExecutor.awaitTermination(1L, TimeUnit.SECONDS)) {
                this.nonCriticalExecutor.shutdownNow();
            }
            if (!this.criticalExecutor.isTerminated()) {
                this.criticalExecutor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            this.logger.error("Processing shutdown thread interrupted: " + e.getMessage());
            this.nonCriticalExecutor.shutdownNow();
            this.criticalExecutor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }
}

