/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.processing.processors.player;

import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.PlayerKill;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.processing.CriticalRunnable;
import java.util.Optional;
import java.util.UUID;

public class PlayerKillProcessor
implements CriticalRunnable {
    private final UUID killer;
    private final UUID victim;
    private final String weaponName;
    private final long time;

    public PlayerKillProcessor(UUID killer, long time, UUID victim, String weaponName) {
        this.killer = killer;
        this.time = time;
        this.victim = victim;
        this.weaponName = weaponName;
    }

    @Override
    public void run() {
        Optional<Session> cachedSession = SessionCache.getCachedSession(this.killer);
        if (!cachedSession.isPresent()) {
            return;
        }
        Session session = cachedSession.get();
        session.playerKilled(new PlayerKill(this.victim, this.weaponName, this.time));
    }
}

