/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.query;

import com.djrapitops.plan.gathering.cache.SessionCache;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.query.CommonQueries;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.queries.objects.SessionQueries;
import com.djrapitops.plan.storage.database.queries.objects.UserIdentifierQueries;
import com.djrapitops.plan.storage.database.queries.schema.H2SchemaQueries;
import com.djrapitops.plan.storage.database.queries.schema.MySQLSchemaQueries;
import com.djrapitops.plan.storage.database.queries.schema.SQLiteSchemaQueries;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;

public class CommonQueriesImplementation
implements CommonQueries {
    private final Database db;

    CommonQueriesImplementation(Database db) {
        this.db = db;
    }

    @Override
    public long fetchPlaytime(UUID playerUUID, UUID serverUUID, long after, long before) {
        return this.db.query(SessionQueries.playtimeOfPlayer(after, before, playerUUID)).getOrDefault(serverUUID, 0L);
    }

    @Override
    public long fetchCurrentSessionPlaytime(UUID playerUUID) {
        return SessionCache.getCachedSession(playerUUID).map(Session::getLength).orElse(0L);
    }

    @Override
    public long fetchLastSeen(UUID playerUUID, UUID serverUUID) {
        return this.db.query(SessionQueries.lastSeen(playerUUID, serverUUID));
    }

    @Override
    public Set<UUID> fetchServerUUIDs() {
        return this.db.query(ServerQueries.fetchServerNames()).keySet();
    }

    @Override
    public Optional<UUID> fetchUUIDOf(String playerName) {
        return this.db.query(UserIdentifierQueries.fetchPlayerUUIDOf(playerName));
    }

    @Override
    public Optional<String> fetchNameOf(UUID playerUUID) {
        return this.db.query(UserIdentifierQueries.fetchPlayerNameOf(playerUUID));
    }

    @Override
    public boolean doesDBHaveTable(String table) {
        DBType dbType = this.db.getType();
        switch (dbType) {
            case H2: {
                return this.db.query(H2SchemaQueries.doesTableExist(table));
            }
            case SQLITE: {
                return this.db.query(SQLiteSchemaQueries.doesTableExist(table));
            }
            case MYSQL: {
                return this.db.query(MySQLSchemaQueries.doesTableExist(table));
            }
        }
        throw new IllegalStateException("Unsupported Database Type: " + dbType.getName());
    }

    @Override
    public boolean doesDBHaveTableColumn(String table, String column) {
        DBType dbType = this.db.getType();
        switch (dbType) {
            case H2: {
                return this.db.query(H2SchemaQueries.doesColumnExist(table, column));
            }
            case MYSQL: {
                return this.db.query(MySQLSchemaQueries.doesColumnExist(table, column));
            }
            case SQLITE: {
                return this.db.query(SQLiteSchemaQueries.doesColumnExist(table, column));
            }
        }
        throw new IllegalStateException("Unsupported Database Type: " + dbType.getName());
    }
}

