/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.query;

import com.djrapitops.plan.query.CommonQueries;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.Consumer;

public interface QueryService {
    public static QueryService getInstance() {
        return Optional.ofNullable(Holder.service).orElseThrow(() -> new IllegalStateException("QueryService has not been initialised yet."));
    }

    public String getDBType();

    public <T> T query(String var1, ThrowingFunction<PreparedStatement, T> var2) throws IllegalStateException;

    public Future<?> execute(String var1, ThrowingConsumer<PreparedStatement> var2) throws IllegalStateException;

    public void subscribeToPlayerRemoveEvent(Consumer<UUID> var1);

    public void subscribeDataClearEvent(VoidFunction var1);

    public Optional<UUID> getServerUUID();

    public CommonQueries getCommonQueries();

    public static class Holder {
        static QueryService service;

        private Holder() {
        }

        static void set(QueryService service) {
            Holder.service = service;
        }
    }

    @FunctionalInterface
    public static interface VoidFunction {
        public void apply();
    }

    @FunctionalInterface
    public static interface ThrowingFunction<T, R> {
        public R apply(T var1) throws SQLException;
    }

    @FunctionalInterface
    public static interface ThrowingConsumer<T> {
        public void accept(T var1) throws SQLException;
    }
}

