/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.query;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.query.CommonQueries;
import com.djrapitops.plan.query.CommonQueriesImplementation;
import com.djrapitops.plan.query.QueryService;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.QueryAPIExecutable;
import com.djrapitops.plan.storage.database.queries.QueryAPIQuery;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.sql.PreparedStatement;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class QuerySvc
implements QueryService {
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private final Set<Consumer<UUID>> playerRemoveSubscribers;
    private final Set<QueryService.VoidFunction> clearSubscribers;

    @Inject
    public QuerySvc(DBSystem dbSystem, ServerInfo serverInfo, PluginLogger logger, ErrorLogger errorLogger) {
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.playerRemoveSubscribers = new HashSet<Consumer<UUID>>();
        this.clearSubscribers = new HashSet<QueryService.VoidFunction>();
    }

    public void register() {
        QueryService.Holder.set(this);
    }

    @Override
    public String getDBType() {
        Database database = this.dbSystem.getDatabase();
        if (database == null) {
            throw new IllegalStateException("Database has not been initialized.");
        }
        return database.getType().name();
    }

    @Override
    public <T> T query(String sql, QueryService.ThrowingFunction<PreparedStatement, T> performQuery) {
        return this.dbSystem.getDatabase().query(new QueryAPIQuery<T>(sql, performQuery));
    }

    @Override
    public Future<?> execute(final String sql, final QueryService.ThrowingConsumer<PreparedStatement> performStatement) {
        return this.dbSystem.getDatabase().executeTransaction(new Transaction(){

            @Override
            protected void performOperations() {
                this.execute(new QueryAPIExecutable(sql, performStatement));
            }
        });
    }

    @Override
    public void subscribeToPlayerRemoveEvent(Consumer<UUID> eventListener) {
        this.playerRemoveSubscribers.add(eventListener);
    }

    @Override
    public void subscribeDataClearEvent(QueryService.VoidFunction eventListener) {
        this.clearSubscribers.add(eventListener);
    }

    public void playerRemoved(UUID playerUUID) {
        this.playerRemoveSubscribers.forEach(subscriber -> {
            try {
                subscriber.accept(playerUUID);
            }
            catch (DBOpException e) {
                this.errorLogger.log(L.WARN, e, ErrorContext.builder().whatToDo("Report to this Query API user " + subscriber.getClass().getName()).related((Object)("Subscriber: " + subscriber.getClass().getName())).build());
            }
        });
    }

    public void dataCleared() {
        this.clearSubscribers.forEach(function -> {
            try {
                function.apply();
            }
            catch (DBOpException e) {
                this.errorLogger.log(L.WARN, e, ErrorContext.builder().whatToDo("Report to this Query API user " + function.getClass().getName()).related((Object)("Subscriber: " + function.getClass().getName())).build());
            }
        });
    }

    @Override
    public Optional<UUID> getServerUUID() {
        return this.serverInfo.getServerUUIDSafe();
    }

    @Override
    public CommonQueries getCommonQueries() {
        Database database = this.dbSystem.getDatabase();
        if (database == null) {
            throw new IllegalStateException("Database has not been initialized.");
        }
        return new CommonQueriesImplementation(database);
    }
}

