/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.TimeZoneUtility;
import com.djrapitops.plan.settings.config.paths.FormatSettings;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.logging.debug.CombineDebugLogger;
import com.djrapitops.plugin.logging.debug.ConsoleDebugLogger;
import com.djrapitops.plugin.logging.debug.DebugLogger;
import com.djrapitops.plugin.logging.debug.FolderTimeStampFileDebugLogger;
import com.djrapitops.plugin.logging.debug.MemoryDebugLogger;
import com.djrapitops.plugin.utilities.Verify;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.TimeZone;
import plan.javax.inject.Singleton;

@Singleton
public abstract class ConfigSystem
implements SubSystem {
    protected final PlanFiles files;
    protected final PlanConfig config;
    protected final Theme theme;
    protected final PluginLogger logger;
    protected final ErrorLogger errorLogger;

    public ConfigSystem(PlanFiles files, PlanConfig config, Theme theme, PluginLogger logger, ErrorLogger errorLogger) {
        this.files = files;
        this.config = config;
        this.theme = theme;
        this.logger = logger;
        this.errorLogger = errorLogger;
    }

    public PlanConfig getConfig() {
        return this.config;
    }

    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public void enable() throws EnableException {
        try {
            this.copyDefaults();
            this.config.reorder(Arrays.asList("Server", "Network", "Plugin", "Database", "Webserver", "Data_gathering", "Time", "Display_options", "Formatting", "World_aliases", "Export", "Plugins"));
            this.config.save();
            if (this.logger.getDebugLogger() instanceof CombineDebugLogger) {
                this.setDebugMode();
            }
            this.checkWrongTimeZone();
        }
        catch (IOException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Fix write permissions to " + this.config.getConfigFilePath()).build());
            throw new EnableException("Failed to save default config: " + e.getMessage(), e);
        }
        this.theme.enable();
    }

    public void checkWrongTimeZone() {
        String timeZone = this.config.get(FormatSettings.TIMEZONE);
        Optional<TimeZone> foundTZ = TimeZoneUtility.parseTimeZone(timeZone);
        if (!foundTZ.isPresent()) {
            this.logger.warn("Config: " + FormatSettings.TIMEZONE.getPath() + " has invalid value '" + timeZone + "', using GMT+0");
        }
    }

    private void setDebugMode() {
        CombineDebugLogger debugLogger = (CombineDebugLogger)this.logger.getDebugLogger();
        String debugMode = this.config.get(PluginSettings.DEBUG);
        ArrayList<DebugLogger> loggers = new ArrayList<DebugLogger>();
        if (Verify.containsOne(debugMode, "true", "both", "all", "console")) {
            loggers.add(new ConsoleDebugLogger(this.logger));
        }
        if (Verify.containsOne(debugMode, "true", "both", "all", "file")) {
            loggers.add(new FolderTimeStampFileDebugLogger(this.files.getLogsFolder(), () -> this.errorLogger));
        }
        if (Verify.containsOne(debugMode, "true", "both", "all", "memory")) {
            loggers.add(debugLogger.getDebugLogger(MemoryDebugLogger.class).orElse(new MemoryDebugLogger()));
        }
        debugLogger.setDebugLoggers(loggers.toArray(new DebugLogger[0]));
    }

    protected abstract void copyDefaults() throws IOException;

    @Override
    public void disable() {
        this.theme.disable();
    }

    public void reload() {
        try {
            this.config.read();
        }
        catch (IOException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Fix read permissions to " + this.config.getConfigFilePath()).build());
        }
    }
}

