/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings;

import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.settings.ConfigSystem;
import com.djrapitops.plan.settings.config.ConfigReader;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.changes.ConfigUpdater;
import com.djrapitops.plan.settings.config.paths.DatabaseSettings;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.network.ServerSettingsManager;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.IOException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NukkitConfigSystem
extends ConfigSystem {
    private final ConfigUpdater configUpdater;
    private final ServerSettingsManager serverSettingsManager;
    private boolean firstInstall;

    @Inject
    public NukkitConfigSystem(PlanFiles files, PlanConfig config, ConfigUpdater configUpdater, ServerSettingsManager serverSettingsManager, Theme theme, PluginLogger logger, ErrorLogger errorLogger) {
        super(files, config, theme, logger, errorLogger);
        this.configUpdater = configUpdater;
        this.serverSettingsManager = serverSettingsManager;
    }

    @Override
    public void enable() throws EnableException {
        this.firstInstall = !this.files.getConfigFile().exists();
        super.enable();
        if (this.config.isTrue(PluginSettings.PROXY_COPY_CONFIG)) {
            this.serverSettingsManager.enable();
        }
    }

    @Override
    public void disable() {
        this.serverSettingsManager.disable();
        super.disable();
    }

    @Override
    protected void copyDefaults() throws IOException {
        this.configUpdater.applyConfigUpdate(this.config);
        try (ConfigReader reader = new ConfigReader(this.files.getResourceFromJar("config.yml").asInputStream());){
            this.config.copyMissing(reader.read());
        }
        String dbType = this.config.get(DatabaseSettings.TYPE);
        if ("sqlite".equalsIgnoreCase(dbType)) {
            if (!this.firstInstall) {
                this.logger.warn("'SQLite' is not supported on Nukkit, switching to 'H2'.");
            }
            this.config.set(DatabaseSettings.TYPE, "H2");
        }
    }
}

