/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings;

import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.settings.ConfigSystem;
import com.djrapitops.plan.settings.config.ConfigReader;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.changes.ConfigUpdater;
import com.djrapitops.plan.settings.network.NetworkSettingManager;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.IOException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ProxyConfigSystem
extends ConfigSystem {
    private final ConfigUpdater configUpdater;
    private final NetworkSettingManager networkSettingManager;

    @Inject
    public ProxyConfigSystem(PlanFiles files, PlanConfig config, ConfigUpdater configUpdater, NetworkSettingManager networkSettingManager, Theme theme, PluginLogger logger, ErrorLogger errorLogger) {
        super(files, config, theme, logger, errorLogger);
        this.configUpdater = configUpdater;
        this.networkSettingManager = networkSettingManager;
    }

    @Override
    public void enable() throws EnableException {
        super.enable();
        this.networkSettingManager.enable();
    }

    @Override
    public void disable() {
        this.networkSettingManager.disable();
        super.disable();
    }

    @Override
    protected void copyDefaults() throws IOException {
        this.configUpdater.applyConfigUpdate(this.config);
        try (ConfigReader reader = new ConfigReader(this.files.getResourceFromJar("bungeeconfig.yml").asInputStream());){
            this.config.copyMissing(reader.read());
        }
    }
}

