/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings;

import com.djrapitops.plan.settings.SettingsService;
import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class SettingsSvc
implements SettingsService {
    private final PlanConfig config;
    private final ErrorLogger errorLogger;

    @Inject
    public SettingsSvc(PlanConfig config, ErrorLogger errorLogger) {
        this.config = config;
        this.errorLogger = errorLogger;
    }

    public void register() {
        SettingsService.Holder.set(this);
    }

    @Override
    public String getString(String path, Supplier<String> defaultValue) {
        String pluginPath = this.getPluginPath(path);
        Optional<ConfigNode> node = this.config.getNode(pluginPath);
        if (node.isPresent()) {
            return node.get().getString();
        }
        this.set(pluginPath, defaultValue);
        return this.config.getString(pluginPath);
    }

    public <T> void set(String pluginPath, Supplier<T> defaultValue) {
        this.config.set(pluginPath, defaultValue.get());
        try {
            this.config.save();
        }
        catch (IOException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Fix write permissions to " + this.config.getConfigFilePath()).build());
        }
    }

    @Override
    public Integer getInteger(String path, Supplier<Integer> defaultValue) {
        String pluginPath = this.getPluginPath(path);
        Optional<ConfigNode> node = this.config.getNode(pluginPath);
        if (node.isPresent()) {
            return node.get().getInteger();
        }
        this.set(pluginPath, defaultValue);
        return this.config.getInteger(pluginPath);
    }

    @Override
    public List<String> getStringList(String path, Supplier<List<String>> defaultValue) {
        String pluginPath = this.getPluginPath(path);
        Optional<ConfigNode> node = this.config.getNode(pluginPath);
        if (node.isPresent()) {
            return node.get().getStringList();
        }
        this.set(pluginPath, defaultValue);
        return this.config.getStringList(pluginPath);
    }

    private String getPluginPath(String path) {
        return "Plugins." + path;
    }
}

