/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings;

import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.settings.BukkitConfigSystem;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.changes.ConfigUpdater;
import com.djrapitops.plan.settings.config.paths.DataGatheringSettings;
import com.djrapitops.plan.settings.config.paths.WebserverSettings;
import com.djrapitops.plan.settings.network.ServerSettingsManager;
import com.djrapitops.plan.settings.theme.Theme;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.IOException;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class SpongeConfigSystem
extends BukkitConfigSystem {
    private boolean firstInstall;

    @Inject
    public SpongeConfigSystem(PlanFiles files, PlanConfig config, ConfigUpdater configUpdater, ServerSettingsManager serverSettingsManager, Theme theme, PluginLogger logger, ErrorLogger errorLogger) {
        super(files, config, configUpdater, serverSettingsManager, theme, logger, errorLogger);
    }

    @Override
    public void enable() throws EnableException {
        this.firstInstall = !this.files.getConfigFile().exists();
        super.enable();
    }

    @Override
    protected void copyDefaults() throws IOException {
        super.copyDefaults();
        if (this.firstInstall) {
            this.logger.info("\u00a7eWebServer and Geolocations disabled by default on Sponge servers. You can enable them in the config:");
            this.logger.info("\u00a7e  " + WebserverSettings.DISABLED.getPath());
            this.logger.info("\u00a7e  " + DataGatheringSettings.GEOLOCATIONS.getPath());
            this.config.set(WebserverSettings.DISABLED, Boolean.valueOf(true));
            this.config.set(DataGatheringSettings.GEOLOCATIONS, Boolean.valueOf(false));
            this.config.save();
        }
    }
}

