/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plan.settings.config.ConfigReader;
import com.djrapitops.plan.settings.config.ConfigWriter;
import com.djrapitops.plugin.utilities.Verify;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;

public class Config
extends ConfigNode {
    private final Path configFilePath;

    public Config(File configFile) {
        super("", null, null);
        File folder = configFile.getParentFile();
        this.configFilePath = configFile.toPath();
        try {
            Verify.isTrue(folder.exists() || folder.mkdirs(), () -> new FileNotFoundException("Folders could not be created for config file " + configFile.getAbsolutePath()));
            Verify.isTrue(configFile.exists() || configFile.createNewFile(), () -> new FileNotFoundException("Could not create file: " + configFile.getAbsolutePath()));
            this.read();
            this.save();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    public Config(File configFile, ConfigNode defaults) {
        this(configFile);
        this.copyMissing(defaults);
        try {
            this.save();
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    Config() {
        super("", null, null);
        this.configFilePath = null;
    }

    public void read() throws IOException {
        try (ConfigReader reader = new ConfigReader(Files.newInputStream(this.configFilePath, new OpenOption[0]));){
            this.copyAll(reader.read());
        }
    }

    @Override
    public void save() throws IOException {
        new ConfigWriter(this.configFilePath).write(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.configFilePath);
    }

    public Path getConfigFilePath() {
        return this.configFilePath;
    }
}

