/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plan.settings.config.ConfigValueParser;
import com.djrapitops.plugin.utilities.Verify;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import plan.org.apache.commons.lang3.StringUtils;

public class ConfigNode {
    protected final String key;
    protected ConfigNode parent;
    protected List<String> nodeOrder;
    protected final Map<String, ConfigNode> childNodes;
    protected List<String> comment;
    protected String value;

    public ConfigNode(String key, ConfigNode parent, String value) {
        this.key = key;
        this.parent = parent;
        this.value = value;
        this.nodeOrder = new CopyOnWriteArrayList<String>();
        this.childNodes = new HashMap<String, ConfigNode>();
        this.comment = new ArrayList<String>();
    }

    protected void updateParent(ConfigNode newParent) {
        this.parent = newParent;
    }

    public Optional<ConfigNode> getNode(String path) {
        if (path == null) {
            return Optional.empty();
        }
        String[] parts = this.splitPathInTwo(path);
        String key = parts[0];
        String leftover = parts[1];
        if (leftover.isEmpty()) {
            return Optional.ofNullable(this.childNodes.get(key));
        }
        return this.getNode(key).flatMap(child -> child.getNode(leftover));
    }

    private String[] splitPathInTwo(String path) {
        String[] split = StringUtils.split(path, ".", 2);
        if (split.length <= 1) {
            return new String[]{split[0], ""};
        }
        return split;
    }

    public boolean contains(String path) {
        return this.getNode(path).isPresent();
    }

    public ConfigNode addNode(String path) {
        ConfigNode newParent = this;
        if (path != null && !path.isEmpty()) {
            String[] parts = this.splitPathInTwo(path);
            String key = parts[0];
            String leftover = parts[1];
            ConfigNode child = !this.childNodes.containsKey(key) ? this.addChild(new ConfigNode(key, newParent, null)) : this.childNodes.get(key);
            return leftover.isEmpty() ? child : child.addNode(leftover);
        }
        throw new IllegalArgumentException("Can not add a node with path '" + path + "'");
    }

    public boolean removeNode(String path) {
        Optional<ConfigNode> node = this.getNode(path);
        node.ifPresent(ConfigNode::remove);
        return node.isPresent();
    }

    public void remove() {
        if (this.parent == null) {
            throw new IllegalStateException("Can not remove root node from a tree.");
        }
        this.parent.childNodes.remove(this.key);
        this.parent.nodeOrder.remove(this.key);
        this.updateParent(null);
        this.nodeOrder.stream().sorted().map(this.childNodes::get).filter(Objects::nonNull).forEach(ConfigNode::remove);
    }

    protected ConfigNode addChild(ConfigNode child) {
        this.getNode(child.key).ifPresent(ConfigNode::remove);
        this.childNodes.put(child.key, child);
        this.nodeOrder.add(child.key);
        child.updateParent(this);
        return child;
    }

    protected void removeChild(ConfigNode child) {
        this.removeNode(child.key);
    }

    public boolean moveChild(String oldPath, String newPath) {
        Optional<ConfigNode> found = this.getNode(oldPath);
        if (!found.isPresent()) {
            return false;
        }
        ConfigNode moveFrom = found.get();
        ConfigNode moveTo = this.addNode(newPath);
        moveTo.copyAll(moveFrom);
        this.removeNode(oldPath);
        return this.getNode(newPath).isPresent();
    }

    public String getKey(boolean deep) {
        if (deep) {
            String deepKey;
            String string = deepKey = this.parent != null ? this.parent.getKey(true) + "." + this.key : "";
            if (deepKey.startsWith(".")) {
                return deepKey.substring(1);
            }
            return deepKey;
        }
        return this.key;
    }

    public void sort() {
        Collections.sort(this.nodeOrder);
    }

    public void reorder(List<String> newOrder) {
        List<String> oldOrder = this.nodeOrder;
        this.nodeOrder = new ArrayList<String>();
        for (String key : newOrder) {
            if (!this.childNodes.containsKey(key)) continue;
            this.nodeOrder.add(key);
        }
        oldOrder.removeAll(this.nodeOrder);
        this.nodeOrder.addAll(oldOrder);
    }

    public void save() throws IOException {
        ConfigNode root = this.parent;
        while (root.parent != null) {
            root = root.parent;
        }
        root.save();
    }

    public <T> void set(String path, T value) {
        this.addNode(path).set(value);
    }

    public <T> void set(T value) {
        if (value instanceof ConfigNode) {
            this.copyAll((ConfigNode)value);
        } else {
            ConfigValueParser parser = ConfigValueParser.getParserFor(value.getClass());
            this.value = parser.decompose(value);
        }
    }

    public List<String> getComment() {
        return this.comment;
    }

    public void setComment(List<String> comment) {
        this.comment = comment;
    }

    public List<String> getStringList() {
        return this.value == null ? Collections.emptyList() : new ConfigValueParser.StringListParser().compose(this.value);
    }

    public Integer getInteger() {
        return this.value == null ? null : new ConfigValueParser.IntegerParser().compose(this.value);
    }

    public Long getLong() {
        return this.value == null ? null : new ConfigValueParser.LongParser().compose(this.value);
    }

    public String getString() {
        return this.value == null ? null : new ConfigValueParser.StringParser().compose(this.value);
    }

    public boolean getBoolean() {
        return new ConfigValueParser.BooleanParser().compose(this.value);
    }

    public List<String> getStringList(String path) {
        return this.getNode(path).map(ConfigNode::getStringList).orElse(Collections.emptyList());
    }

    public Map<String, String> getStringMap(boolean fullKeys) {
        return this.childNodes.values().stream().collect(Collectors.toMap(node -> node.getKey(fullKeys), ConfigNode::getString));
    }

    public Integer getInteger(String path) {
        return this.getNode(path).map(ConfigNode::getInteger).orElse(null);
    }

    public Long getLong(String path) {
        return this.getNode(path).map(ConfigNode::getLong).orElse(null);
    }

    public String getString(String path) {
        return this.getNode(path).map(ConfigNode::getString).orElse(null);
    }

    public boolean getBoolean(String path) {
        return this.getNode(path).map(ConfigNode::getBoolean).orElse(false);
    }

    public void copyMissing(ConfigNode from) {
        if (this.comment.size() < from.comment.size()) {
            this.comment = from.comment;
        }
        if (Verify.isEmpty(this.value) && from.value != null) {
            this.value = from.value;
        }
        for (String key : from.nodeOrder) {
            ConfigNode newChild = from.childNodes.get(key);
            ConfigNode created = this.addNode(key);
            created.copyMissing(newChild);
        }
    }

    public void copyAll(ConfigNode from) {
        this.comment = from.comment;
        this.value = from.value;
        for (String key : from.nodeOrder) {
            ConfigNode newChild = from.childNodes.get(key);
            ConfigNode created = this.addNode(key);
            created.copyAll(newChild);
        }
    }

    protected int getNodeDepth() {
        return this.parent != null ? this.parent.getNodeDepth() + 1 : -1;
    }

    public ConfigNode getParent() {
        return this.parent;
    }

    public boolean isLeafNode() {
        return this.nodeOrder.isEmpty();
    }

    protected List<String> getNodeOrder() {
        return this.nodeOrder;
    }

    public Collection<ConfigNode> getChildren() {
        return this.childNodes.values();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ConfigNode)) {
            return false;
        }
        ConfigNode that = (ConfigNode)o;
        return Objects.equals(this.key, that.key) && this.nodeOrder.equals(that.nodeOrder) && this.childNodes.equals(that.childNodes) && this.comment.equals(that.comment) && Objects.equals(this.value, that.value);
    }

    public int hashCode() {
        return Objects.hash(this.key, this.childNodes, this.comment, this.value);
    }

    public String toString() {
        return "{'" + this.value + "' " + (!this.childNodes.isEmpty() ? this.childNodes : "") + '}';
    }
}

