/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plugin.utilities.Verify;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;

public class ConfigReader
implements Closeable {
    private boolean closed;
    private final Scanner scanner;
    private ConfigNode previousNode;
    private ConfigNode parent;
    private int indentMode = 4;
    private final List<String> unboundComment = new ArrayList<String>();
    private int lastDepth = -1;

    public ConfigReader(Path filePath) throws IOException {
        this(Files.newInputStream(filePath, new OpenOption[0]));
    }

    public ConfigReader(InputStream in) {
        this(new Scanner(new InputStreamReader(in, StandardCharsets.UTF_8)));
    }

    public ConfigReader(BufferedReader bufferedReader) {
        this(new Scanner(bufferedReader));
    }

    public ConfigReader(Scanner scanner) {
        this.scanner = scanner;
        this.closed = false;
    }

    public Config read() {
        Verify.isFalse(this.closed, () -> new IllegalStateException("ConfigReader has been closed."));
        Config config = new Config();
        this.previousNode = config;
        this.parent = config;
        while (this.scanner.hasNextLine()) {
            String line = this.readNewLine();
            String trimmed = line.trim();
            this.handleLine(line, trimmed);
        }
        return config;
    }

    private void handleLine(String line, String trimmed) {
        if (trimmed.isEmpty() || trimmed.startsWith(":")) {
            this.handleCommentLine(" ");
        } else if (trimmed.startsWith("#")) {
            this.handleCommentLine(trimmed);
        } else {
            int currentDepth = this.findCurrentDepth(line);
            this.parent = this.findParent(this.lastDepth, currentDepth);
            Verify.nullCheck(this.parent, () -> new IllegalStateException("Could not determine parent on line: \"" + line + "\""));
            this.previousNode = this.parseNode(trimmed);
            Verify.nullCheck(this.previousNode, () -> new IllegalStateException("Could not parse node on line: \"" + line + "\""));
            this.lastDepth = currentDepth;
            this.handleUnboundComments();
        }
    }

    private String readNewLine() {
        String line = this.scanner.nextLine();
        int danglingComment = line.trim().indexOf(" #");
        if (danglingComment != -1) {
            line = line.substring(0, danglingComment);
        }
        return line;
    }

    private ConfigNode parseNode(String line) {
        String[] keyAndValue = line.split(":", 2);
        if (keyAndValue.length <= 1 || line.startsWith("- ")) {
            return this.handleMultiline(line);
        }
        String key = keyAndValue[0].trim();
        String value = keyAndValue[1].trim();
        return this.handleNewNode(key, !value.isEmpty() ? value : null);
    }

    private ConfigNode handleMultiline(String line) {
        if (line.startsWith("- ")) {
            return this.handleListCase(line);
        }
        return this.handleMultilineString(line);
    }

    private void handleCommentLine(String line) {
        this.unboundComment.add(line.substring(1).trim());
    }

    private void handleUnboundComments() {
        if (!this.unboundComment.isEmpty()) {
            this.previousNode.setComment(new ArrayList<String>(this.unboundComment));
            this.unboundComment.clear();
        }
    }

    private ConfigNode handleMultilineString(String line) {
        if (this.previousNode.value == null) {
            this.previousNode.value = "";
        }
        this.previousNode.value = this.previousNode.value + line.trim();
        return this.previousNode;
    }

    private ConfigNode handleNewNode(String key, String value) {
        ConfigNode newNode = new ConfigNode(key, this.parent, value);
        return this.parent.addChild(newNode);
    }

    private ConfigNode handleListCase(String line) {
        if (this.previousNode.value == null) {
            this.previousNode.value = "";
        }
        this.previousNode.value = this.previousNode.value + "\n- " + line.substring(2).trim();
        return this.previousNode;
    }

    private ConfigNode findParent(int previousDepth, int currentDepth) {
        if (previousDepth < currentDepth) {
            return this.previousNode;
        }
        if (previousDepth > currentDepth) {
            int helperDepth = previousDepth;
            ConfigNode foundParent = this.previousNode;
            while (helperDepth > currentDepth) {
                helperDepth = foundParent.getNodeDepth();
                foundParent = foundParent.parent;
            }
            return foundParent;
        }
        return this.parent;
    }

    private int findCurrentDepth(String line) {
        int indent = this.readIndent(line);
        if (indent == 2 && this.indentMode == 4) {
            this.indentMode = indent;
        }
        int depth = indent % this.indentMode == 0 ? indent / this.indentMode : (indent - indent % this.indentMode) / this.indentMode + 1;
        return depth;
    }

    private int readIndent(String line) {
        int indentation = 0;
        for (char c : line.toCharArray()) {
            if (c != ' ') break;
            ++indentation;
        }
        return indentation;
    }

    @Override
    public void close() {
        this.scanner.close();
        this.closed = true;
    }
}

