/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plugin.utilities.Verify;
import java.util.ArrayList;
import java.util.List;
import plan.org.apache.commons.lang3.StringUtils;
import plan.org.apache.commons.lang3.math.NumberUtils;

public interface ConfigValueParser<T> {
    public static ConfigValueParser getParserFor(Class type) {
        if (String.class.isAssignableFrom(type)) {
            return new StringParser();
        }
        if (List.class.isAssignableFrom(type)) {
            return new StringListParser();
        }
        if (Boolean.class.isAssignableFrom(type)) {
            return new BooleanParser();
        }
        if (Long.class.isAssignableFrom(type)) {
            return new LongParser();
        }
        if (Integer.class.isAssignableFrom(type)) {
            return new IntegerParser();
        }
        return ConfigValueParser.toStringParser();
    }

    public static ConfigValueParser toStringParser() {
        return new ConfigValueParser(){

            public Object compose(String fromValue) {
                return fromValue;
            }

            public String decompose(Object ofValue) {
                return ofValue.toString();
            }
        };
    }

    public T compose(String var1);

    public String decompose(T var1);

    public static IllegalArgumentException nullInvalidException() {
        return new IllegalArgumentException("Null value is not valid for saving");
    }

    public static class StringListParser
    implements ConfigValueParser<List<String>> {
        private static final StringParser STRING_PARSER = new StringParser();

        @Override
        public List<String> compose(String fromValue) {
            ArrayList<String> values = new ArrayList<String>();
            for (String line : StringUtils.split(fromValue, "\n")) {
                if (line.trim().isEmpty()) continue;
                line = line.substring(2).trim();
                if ((line = STRING_PARSER.compose(line)).isEmpty()) continue;
                values.add(line);
            }
            return values;
        }

        @Override
        public String decompose(List<String> ofValue) {
            Verify.nullCheck(ofValue, ConfigValueParser::nullInvalidException);
            StringBuilder decomposedString = new StringBuilder();
            for (String value : ofValue) {
                decomposedString.append("\n- ").append(STRING_PARSER.decompose(value));
            }
            return decomposedString.toString();
        }
    }

    public static class BooleanParser
    implements ConfigValueParser<Boolean> {
        @Override
        public Boolean compose(String fromValue) {
            return Boolean.valueOf(fromValue);
        }

        @Override
        public String decompose(Boolean ofValue) {
            Verify.nullCheck(ofValue, ConfigValueParser::nullInvalidException);
            return Boolean.toString(ofValue);
        }
    }

    public static class LongParser
    implements ConfigValueParser<Long> {
        @Override
        public Long compose(String fromValue) {
            try {
                return Long.parseLong(fromValue);
            }
            catch (NumberFormatException e) {
                return null;
            }
        }

        @Override
        public String decompose(Long ofValue) {
            Verify.nullCheck(ofValue, ConfigValueParser::nullInvalidException);
            return Long.toString(ofValue);
        }
    }

    public static class IntegerParser
    implements ConfigValueParser<Integer> {
        @Override
        public Integer compose(String fromValue) {
            if (NumberUtils.isParsable(fromValue)) {
                return NumberUtils.createInteger(fromValue);
            }
            return null;
        }

        @Override
        public String decompose(Integer ofValue) {
            Verify.nullCheck(ofValue, ConfigValueParser::nullInvalidException);
            return Integer.toString(ofValue);
        }
    }

    public static class StringParser
    implements ConfigValueParser<String> {
        @Override
        public String compose(String fromValue) {
            boolean surroundedWithDoubleQuotes;
            boolean surroundedWithSingleQuotes = fromValue.startsWith("'") && fromValue.endsWith("'");
            boolean bl = surroundedWithDoubleQuotes = fromValue.startsWith("\"") && fromValue.endsWith("\"");
            if (surroundedWithSingleQuotes || surroundedWithDoubleQuotes) {
                return fromValue.substring(1, fromValue.length() - 1);
            }
            return fromValue;
        }

        @Override
        public String decompose(String value) {
            boolean startsWithSpecialSymbol;
            Verify.nullCheck(value, ConfigValueParser::nullInvalidException);
            boolean surroundedByQuotes = value.startsWith("'") || value.endsWith("'");
            boolean surroundedByDoubleQuotes = value.startsWith("\"") || value.endsWith("\"");
            boolean containsSpace = value.isEmpty() || value.contains(" ");
            boolean bl = startsWithSpecialSymbol = value.startsWith("-") || value.startsWith("#") || value.startsWith("&");
            if (surroundedByDoubleQuotes || containsSpace || startsWithSpecialSymbol) {
                return "'" + value + "'";
            }
            if (surroundedByQuotes) {
                return "\"" + value + "\"";
            }
            return value;
        }
    }
}

