/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plugin.utilities.Verify;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import plan.org.apache.commons.lang3.StringUtils;

public class ConfigWriter {
    private Path outputPath;
    private int indent;

    public ConfigWriter() {
    }

    public ConfigWriter(Path outputPath) {
        this.outputPath = outputPath;
    }

    public void write(ConfigNode writing) throws IOException {
        Verify.nullCheck(this.outputPath, () -> new IllegalStateException("Output path was null."));
        ConfigNode storedParent = writing.parent;
        writing.updateParent(null);
        Path directory = this.outputPath.getParent();
        if (!directory.toRealPath(new LinkOption[0]).toFile().isDirectory()) {
            Files.createDirectories(directory, new FileAttribute[0]);
        }
        Files.write(this.outputPath, this.createLines(writing), StandardCharsets.UTF_8, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
        writing.updateParent(storedParent);
    }

    public List<String> createLines(ConfigNode writing) {
        ArrayList<String> lines = new ArrayList<String>();
        this.dfsTreeTraverseLineResolve(writing, lines);
        return lines;
    }

    private void dfsTreeTraverseLineResolve(ConfigNode writing, Collection<String> lines) {
        Map<String, ConfigNode> children = writing.childNodes;
        for (String key : writing.getNodeOrder()) {
            ConfigNode node = children.get(key);
            if (node.value == null && node.nodeOrder.isEmpty()) continue;
            this.indent = node.getNodeDepth() * 4;
            this.addComment(node.comment, lines);
            this.addValue(node, lines);
            this.dfsTreeTraverseLineResolve(node, lines);
        }
    }

    private void addValue(ConfigNode node, Collection<String> lines) {
        String key = node.key;
        String value = node.value;
        if (value == null || value.isEmpty()) {
            this.addKey(key, lines);
        } else if (StringUtils.contains((CharSequence)value, "\n")) {
            this.addListValue(key, StringUtils.split(value, "\n"), lines);
        } else {
            this.addNormalValue(key, value, lines);
        }
    }

    private void addKey(String key, Collection<String> lines) {
        lines.add(this.indentedBuilder().append(key).append(":").toString());
    }

    private void addNormalValue(String key, String value, Collection<String> lines) {
        StringBuilder lineBuilder = this.indentedBuilder().append(key).append(": ").append(value);
        lines.add(lineBuilder.toString());
    }

    private void addListValue(String key, String[] listItems, Collection<String> lines) {
        this.addKey(key, lines);
        for (String listItem : listItems) {
            if ((listItem = listItem.trim()).isEmpty()) continue;
            this.addListItem(listItem, lines);
        }
    }

    private void addListItem(String listItem, Collection<String> lines) {
        StringBuilder lineBuilder = this.indentedBuilder().append("  ").append(listItem);
        lines.add(lineBuilder.toString());
    }

    private void addComment(Iterable<String> comments, Collection<String> lines) {
        for (String comment : comments) {
            StringBuilder lineBuilder = this.indentedBuilder().append("# ").append(comment);
            lines.add(lineBuilder.toString());
        }
    }

    private StringBuilder indentedBuilder() {
        StringBuilder lineBuilder = new StringBuilder();
        this.indent(this.indent, lineBuilder);
        return lineBuilder;
    }

    private void indent(int indent, StringBuilder lineBuilder) {
        for (int i = 0; i < indent; ++i) {
            lineBuilder.append(' ');
        }
    }
}

