/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plan.settings.config.PlanConfig;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;

public class ExtensionSettings {
    private final PlanConfig config;

    public ExtensionSettings(PlanConfig config) {
        this.config = config;
    }

    public boolean hasSection(String pluginName) {
        ConfigNode section = this.getPluginsSection();
        return section.getNode(pluginName + ".Enabled").isPresent();
    }

    private ConfigNode getPluginsSection() {
        return this.config.getNode("Plugins").orElse(this.config.addNode("Plugins"));
    }

    public void createSection(String pluginName) throws IOException {
        ConfigNode section = this.getPluginsSection();
        section.set(pluginName + ".Enabled", true);
        section.sort();
        section.save();
    }

    public boolean isEnabled(String pluginName) {
        ConfigNode section = this.getPluginsSection();
        return section.getBoolean(pluginName + ".Enabled");
    }

    public Set<String> getDisabled() {
        ConfigNode section = this.getPluginsSection();
        HashSet<String> disabledPlugins = new HashSet<String>();
        for (ConfigNode plugin : section.getChildren()) {
            if (!plugin.contains("Enabled") || plugin.getBoolean("Enabled")) continue;
            disabledPlugins.add(plugin.getKey(false));
        }
        return disabledPlugins;
    }
}

