/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ExtensionSettings;
import com.djrapitops.plan.settings.config.ResourceSettings;
import com.djrapitops.plan.settings.config.TimeZoneUtility;
import com.djrapitops.plan.settings.config.WorldAliasSettings;
import com.djrapitops.plan.settings.config.paths.ExportSettings;
import com.djrapitops.plan.settings.config.paths.FormatSettings;
import com.djrapitops.plan.settings.config.paths.key.Setting;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.utilities.Verify;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.time.ZoneId;
import java.util.Objects;
import java.util.Optional;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class PlanConfig
extends Config {
    private final PlanFiles files;
    private final ExtensionSettings extensionSettings;
    private final ResourceSettings resourceSettings;
    private final WorldAliasSettings worldAliasSettings;
    private final PluginLogger logger;

    @Inject
    public PlanConfig(PlanFiles files, WorldAliasSettings worldAliasSettings, PluginLogger logger) {
        this(files.getConfigFile(), files, worldAliasSettings, logger);
    }

    public PlanConfig(File configFile, PlanFiles files, WorldAliasSettings worldAliasSettings, PluginLogger logger) {
        super(configFile);
        this.files = files;
        this.extensionSettings = new ExtensionSettings(this);
        this.resourceSettings = new ResourceSettings(this);
        this.worldAliasSettings = worldAliasSettings;
        this.logger = logger;
    }

    public <T> T get(Setting<T> setting) {
        Object value = setting.getValueFrom(this);
        Verify.isTrue(setting.isValid(value), () -> new IllegalStateException("Config value for " + setting.getPath() + " has a bad value: '" + value + "'"));
        return value;
    }

    public <T> T getOrDefault(Setting<T> setting, T defaultValue) {
        try {
            return this.get(setting);
        }
        catch (IllegalStateException e) {
            this.logger.warn(e.getMessage() + ", using '" + defaultValue + "'");
            return defaultValue;
        }
    }

    public boolean isTrue(Setting<Boolean> setting) {
        return this.get(setting);
    }

    public boolean isFalse(Setting<Boolean> setting) {
        return !this.isTrue(setting);
    }

    public <T> void set(Setting<T> setting, T value) {
        this.set(setting.getPath(), value);
    }

    public TimeZone getTimeZone() {
        String timeZone = this.get(FormatSettings.TIMEZONE);
        Optional<TimeZone> foundTZ = TimeZoneUtility.parseTimeZone(timeZone);
        return foundTZ.orElse(TimeZone.getTimeZone(ZoneId.of("UTC")));
    }

    public int getTimeZoneOffsetHours() {
        int offset = this.getTimeZone().getOffset(System.currentTimeMillis());
        int hourMs = (int)TimeUnit.HOURS.toMillis(1L);
        return -offset / hourMs;
    }

    public Path getPageExportPath() {
        Path exportDirectory = Paths.get(this.get(ExportSettings.HTML_EXPORT_PATH), new String[0]);
        Path customizationDirectory = this.files.getCustomizationDirectory();
        if (exportDirectory.toAbsolutePath().equals(customizationDirectory.toAbsolutePath())) {
            this.logger.warn("'" + ExportSettings.HTML_EXPORT_PATH.getPath() + "' can not be '/Plan/web/' directory, using '/Plan/Analysis Results' as fallback.");
            exportDirectory = this.files.getDataDirectory().resolve("Analysis Results");
        }
        return exportDirectory.isAbsolute() ? exportDirectory : this.files.getDataDirectory().resolve(exportDirectory);
    }

    public Path getJSONExportPath() {
        Path exportDirectory = Paths.get(this.get(ExportSettings.JSON_EXPORT_PATH), new String[0]);
        return exportDirectory.isAbsolute() ? exportDirectory : this.files.getDataDirectory().resolve(exportDirectory);
    }

    public ExtensionSettings getExtensionSettings() {
        return this.extensionSettings;
    }

    public ResourceSettings getResourceSettings() {
        return this.resourceSettings;
    }

    public WorldAliasSettings getWorldAliasSettings() {
        return this.worldAliasSettings;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode());
    }
}

