/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plan.settings.config.PlanConfig;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import plan.org.apache.commons.lang3.StringUtils;

public class ResourceSettings {
    private final PlanConfig config;

    public ResourceSettings(PlanConfig config) {
        this.config = config;
    }

    public boolean shouldBeCustomized(String plugin, String fileName) {
        ConfigNode fileCustomization = this.config.getNode("Customized_files").orElseGet(() -> this.config.addNode("Customized_files"));
        fileCustomization.setComment(Collections.singletonList("The files are placed in /Plan/web/ if the setting is 'true' when accessed."));
        ConfigNode pluginCustomization = fileCustomization.getNode(plugin).orElseGet(() -> fileCustomization.addNode(plugin));
        String fileNameNonPath = StringUtils.replaceChars(fileName, '.', ',');
        if (pluginCustomization.contains(fileNameNonPath)) {
            return pluginCustomization.getBoolean(fileNameNonPath);
        }
        pluginCustomization.set(fileNameNonPath, false);
        try {
            pluginCustomization.sort();
            pluginCustomization.save();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Could not save config.yml: " + e.getMessage(), e);
        }
        return false;
    }
}

