/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config;

import com.djrapitops.plan.delivery.domain.keys.SessionKeys;
import com.djrapitops.plan.delivery.formatting.Formatter;
import com.djrapitops.plan.delivery.formatting.Formatters;
import com.djrapitops.plan.gathering.domain.GMTimes;
import com.djrapitops.plan.gathering.domain.Session;
import com.djrapitops.plan.gathering.domain.WorldTimes;
import com.djrapitops.plan.processing.Processing;
import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import com.djrapitops.plan.settings.locale.lang.HtmlLang;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import plan.dagger.Lazy;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class WorldAliasSettings {
    private final Lazy<PlanConfig> config;
    private final Supplier<Formatter<Double>> percentageFormatter;
    private final Lazy<Locale> locale;
    private final Processing processing;
    private final ErrorLogger errorLogger;

    @Inject
    public WorldAliasSettings(Lazy<PlanConfig> config, Lazy<Locale> locale, Lazy<Formatters> formatters, Processing processing, ErrorLogger errorLogger) {
        this.config = config;
        this.locale = locale;
        this.processing = processing;
        this.errorLogger = errorLogger;
        this.percentageFormatter = () -> ((Formatters)formatters.get()).percentage();
    }

    private ConfigNode getAliasSection() {
        return this.config.get().get(DisplaySettings.WORLD_ALIASES);
    }

    public void addWorld(String world) {
        Verify.isFalse(Verify.isEmpty(world), () -> new IllegalArgumentException("Attempted to save empty world alias"));
        ConfigNode aliasSect = this.getAliasSection();
        String previousValue = aliasSect.getString(world);
        if (Verify.isEmpty(previousValue)) {
            aliasSect.set(world, world);
            this.processing.submitNonCritical(() -> {
                try {
                    aliasSect.save();
                }
                catch (IOException e) {
                    this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Fix write permissions to " + this.config.get().getConfigFilePath()).build());
                }
            });
        }
    }

    public Map<String, Long> getPlaytimePerAlias(WorldTimes worldTimes) {
        if (worldTimes.getWorldTimes().isEmpty()) {
            return new HashMap<String, Long>();
        }
        Map<String, Long> playtimePerWorld = worldTimes.getWorldTimes().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> ((GMTimes)entry.getValue()).getTotal()));
        ConfigNode aliases = this.getAliasSection();
        HashMap<String, Long> playtimePerAlias = new HashMap<String, Long>();
        for (Map.Entry<String, Long> entry2 : playtimePerWorld.entrySet()) {
            String worldName = entry2.getKey();
            long playtime = entry2.getValue();
            if (worldName != null && !aliases.contains(worldName)) {
                this.addWorld(worldName);
            }
            String alias = aliases.getString(worldName);
            playtimePerAlias.put(alias, playtimePerAlias.getOrDefault(alias, 0L) + playtime);
        }
        return playtimePerAlias;
    }

    public Map<String, GMTimes> getGMTimesPerAlias(WorldTimes worldTimes) {
        ConfigNode aliases = this.getAliasSection();
        HashMap<String, GMTimes> gmTimesPerAlias = new HashMap<String, GMTimes>();
        String[] gms = GMTimes.getGMKeyArray();
        for (Map.Entry<String, GMTimes> entry : worldTimes.getWorldTimes().entrySet()) {
            String worldName = entry.getKey();
            GMTimes gmTimes = entry.getValue();
            if (!aliases.contains(worldName)) {
                this.addWorld(worldName);
            }
            String alias = aliases.getString(worldName);
            GMTimes aliasGMTimes = gmTimesPerAlias.getOrDefault(alias, new GMTimes());
            for (String gm : gms) {
                aliasGMTimes.addTime(gm, gmTimes.getTime(gm));
            }
            gmTimesPerAlias.put(alias, aliasGMTimes);
        }
        return gmTimesPerAlias;
    }

    public String getLongestWorldPlayed(Session session) {
        ConfigNode aliases = this.getAliasSection();
        if (!session.supports(SessionKeys.WORLD_TIMES)) {
            return this.locale.get().getString(HtmlLang.UNIT_NO_DATA);
        }
        WorldTimes worldTimes = session.getValue(SessionKeys.WORLD_TIMES).orElse(new WorldTimes());
        if (!session.supports(SessionKeys.END)) {
            return worldTimes.getCurrentWorld().map(currentWorld -> "Current: " + (aliases.contains((String)currentWorld) ? aliases.getString((String)currentWorld) : currentWorld)).orElse("Current: " + this.locale.get().getString(GenericLang.UNAVAILABLE));
        }
        Map<String, Long> playtimePerAlias = this.getPlaytimePerAlias(worldTimes);
        long total = worldTimes.getTotal();
        if (total <= 0L) {
            total = -1L;
        }
        long longest = 0L;
        String theWorld = "-";
        for (Map.Entry<String, Long> entry : playtimePerAlias.entrySet()) {
            String world = entry.getKey();
            long time = entry.getValue();
            if (time <= longest) continue;
            longest = time;
            theWorld = world;
        }
        double quotient = (double)longest * 1.0 / (double)total;
        return theWorld + " (" + (String)this.percentageFormatter.get().apply(quotient) + ")";
    }
}

