/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config.changes;

import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ConfigNode;
import java.util.Collections;
import java.util.Optional;

public interface ConfigChange {
    public boolean hasBeenApplied(Config var1);

    public void apply(Config var1);

    public String getAppliedMessage();

    public static class BooleanToString
    implements ConfigChange {
        private final String oldPath;
        private final String newPath;
        private final String valueIfTrue;
        private final String valueIfFalse;

        public BooleanToString(String oldPath, String newPath, String valueIfTrue, String valueIfFalse) {
            this.oldPath = oldPath;
            this.newPath = newPath;
            this.valueIfTrue = valueIfTrue;
            this.valueIfFalse = valueIfFalse;
        }

        @Override
        public boolean hasBeenApplied(Config config) {
            Optional<ConfigNode> oldNode = config.getNode(this.oldPath);
            return !oldNode.isPresent();
        }

        @Override
        public void apply(Config config) {
            boolean oldValue = config.getBoolean(this.oldPath);
            config.set(this.newPath, oldValue ? this.valueIfTrue : this.valueIfFalse);
            config.removeNode(this.oldPath);
        }

        @Override
        public String getAppliedMessage() {
            return "Moved " + this.oldPath + " to " + this.newPath + " and turned Boolean to String.";
        }
    }

    public static class RemovedComment
    implements ConfigChange {
        private final String path;

        public RemovedComment(String path) {
            this.path = path;
        }

        @Override
        public boolean hasBeenApplied(Config config) {
            Optional<ConfigNode> node = config.getNode(this.path);
            return !node.isPresent() || node.get().getComment().isEmpty();
        }

        @Override
        public void apply(Config config) {
            config.getNode(this.path).ifPresent(node -> node.setComment(Collections.emptyList()));
        }

        @Override
        public String getAppliedMessage() {
            return "Removed Comment from " + this.path;
        }
    }

    public static class Removed
    implements ConfigChange {
        final String oldPath;

        public Removed(String oldPath) {
            this.oldPath = oldPath;
        }

        @Override
        public boolean hasBeenApplied(Config config) {
            return !config.getNode(this.oldPath).isPresent();
        }

        @Override
        public synchronized void apply(Config config) {
            if (!config.removeNode(this.oldPath)) {
                throw new IllegalStateException("Failed to remove config node from '" + this.oldPath + "'");
            }
        }

        @Override
        public String getAppliedMessage() {
            return "Removed " + this.oldPath;
        }
    }

    public static class Copied
    extends Removed {
        final String newPath;

        public Copied(String oldPath, String newPath) {
            super(oldPath);
            this.newPath = newPath;
        }

        @Override
        public synchronized void apply(Config config) {
            config.getNode(this.oldPath).ifPresent(oldNode -> config.addNode(this.newPath).copyAll((ConfigNode)oldNode));
        }

        @Override
        public String getAppliedMessage() {
            return "Copied value of " + this.oldPath + " to " + this.newPath;
        }
    }

    public static class Moved
    extends Removed {
        final String newPath;

        public Moved(String oldPath, String newPath) {
            super(oldPath);
            this.newPath = newPath;
        }

        @Override
        public synchronized void apply(Config config) {
            if (!config.moveChild(this.oldPath, this.newPath)) {
                throw new IllegalStateException("Failed to move config node from '" + this.oldPath + "' to '" + this.newPath + "'");
            }
        }

        @Override
        public String getAppliedMessage() {
            return "Moved " + this.oldPath + " to " + this.newPath;
        }
    }
}

