/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config.paths.key;

import com.djrapitops.plan.delivery.domain.keys.Type;
import com.djrapitops.plan.settings.config.ConfigNode;
import java.util.function.Predicate;

public abstract class Setting<T> {
    protected final String path;
    private final Predicate<T> validator;

    public Setting(String path, Class<T> type) {
        this(path, type, Setting::nullValidator);
    }

    public Setting(String path, Class<T> type, Predicate<T> validator) {
        this(path, Type.ofClass(type), ((Predicate<Object>)Setting::nullValidator).and(validator));
    }

    public Setting(String path, Type<T> type) {
        this(path, type, Setting::nullValidator);
    }

    public Setting(String path, Type<T> type, Predicate<T> validator) {
        this.path = path;
        this.validator = validator;
    }

    public static <T> boolean nullValidator(T value) {
        return value != null;
    }

    public static boolean timeValidator(Number number) {
        return number.doubleValue() > 0.0;
    }

    public String getPath() {
        return this.path;
    }

    public abstract T getValueFrom(ConfigNode var1);

    public boolean isValid(T value) {
        return this.validator.test(value);
    }

    public String toString() {
        throw new UnsupportedOperationException("Setting#toString should not be called, relies on old behavior. Use getValueFrom(ConfigNode) instead. (Called path: '" + this.path + "')");
    }
}

