/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.config.paths.key;

import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plan.settings.config.paths.key.Setting;
import com.djrapitops.plugin.utilities.Verify;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

public class TimeSetting
extends Setting<Long> {
    public TimeSetting(String path) {
        super(path, Long.class, Setting::timeValidator);
    }

    public TimeSetting(String path, Predicate<Long> validator) {
        super(path, Long.class, validator.and(Setting::timeValidator));
    }

    @Override
    public Long getValueFrom(ConfigNode node) {
        Long duration = node.getLong(this.path);
        if (duration == null) {
            return null;
        }
        String unitName = node.getString(this.path + ".Unit");
        try {
            Verify.nullCheck(unitName, () -> new IllegalStateException("Config value for " + this.path + ".Unit has a bad value: 'null'"));
            TimeUnit unit = TimeUnit.valueOf(unitName.toUpperCase());
            return unit.toMillis(duration);
        }
        catch (IllegalArgumentException e) {
            return -1L;
        }
    }
}

