/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.locale;

public enum LangCode {
    CUSTOM("Custom", ""),
    EN("English", "Rsl1122"),
    ES("Spanish", "Catalina & itaquito & Elguerrero"),
    CN("Simplified Chinese", "f0rb1d (\u4f5b\u58c1\u706f) & qsefthuopq & shaokeyibb & Fur_xia"),
    DE("Deutsch", "Eyremba & fuzzlemann & Morsmorse & hallo1142"),
    FI("Finnish", "Rsl1122"),
    FR("French", "CyanTech & Aurelien & Nogapra"),
    IT("Italian", "Malachiel & Mastory_Md5"),
    JA("Japanese", "yukieji"),
    RU("Russian", "Saph1s"),
    TR("Turkish", "TDJisvan"),
    PT_BR("Portuguese (Brazil)", "jvmuller");

    private final String name;
    private final String authors;

    private LangCode(String name, String authors) {
        this.name = name;
        this.authors = authors;
    }

    public static LangCode fromString(String code) {
        try {
            return LangCode.valueOf(code.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return EN;
        }
    }

    public String getName() {
        return this.name;
    }

    public String getAuthors() {
        return this.authors;
    }

    public String getFileName() {
        return "locale_" + this.name() + ".txt";
    }
}

