/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.locale;

import com.djrapitops.plan.settings.locale.LangCode;
import com.djrapitops.plan.settings.locale.LocaleFileReader;
import com.djrapitops.plan.settings.locale.Message;
import com.djrapitops.plan.settings.locale.TranslatedString;
import com.djrapitops.plan.settings.locale.lang.HtmlLang;
import com.djrapitops.plan.settings.locale.lang.JSLang;
import com.djrapitops.plan.settings.locale.lang.Lang;
import com.djrapitops.plan.storage.file.FileResource;
import com.djrapitops.plan.storage.file.PlanFiles;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Locale
extends HashMap<Lang, Message> {
    private LangCode langCode;

    public static Locale forLangCodeString(PlanFiles files, String code) throws IOException {
        return Locale.forLangCode(LangCode.fromString(code), files);
    }

    public Locale() {
        this(LangCode.EN);
    }

    public Locale(LangCode langCode) {
        this.langCode = langCode;
    }

    public static Locale forLangCode(LangCode code, PlanFiles files) throws IOException {
        return new LocaleFileReader(files.getResourceFromJar("locale/" + code.getFileName())).load(code);
    }

    public static Locale fromFile(File file) throws IOException {
        return new LocaleFileReader(new FileResource(file.getName(), file)).load(LangCode.CUSTOM);
    }

    public LangCode getLangCode() {
        return this.langCode;
    }

    @Override
    public Message get(Object key) {
        Message storedValue = (Message)super.get(key);
        if (key instanceof Lang && storedValue == null) {
            return new Message(((Lang)key).getDefault());
        }
        return storedValue;
    }

    public Optional<Message> getNonDefault(Object key) {
        Message storedValue = (Message)super.get(key);
        if (key instanceof Lang && storedValue == null) {
            return Optional.empty();
        }
        return Optional.of(storedValue);
    }

    public String getString(Lang key) {
        return this.get(key).toString();
    }

    public String getString(Lang key, Serializable ... values) {
        return this.get(key).toString(values);
    }

    public String[] getArray(Lang key) {
        return this.get(key).toArray();
    }

    public String[] getArray(Lang key, Serializable ... values) {
        return this.get(key).toArray(values);
    }

    public void loadFromAnotherLocale(Locale locale) {
        this.putAll(locale);
        this.langCode = locale.langCode;
    }

    public String replaceLanguageInHtml(String from) {
        if (this.isEmpty()) {
            return from;
        }
        Pattern scripts = Pattern.compile("(<script id=[\"|'].*[\"|']>[\\s\\S]*?</script>|<script>[\\s\\S]*?</script>|<script src=[\"|'].*[\"|']></script>|<link [\\s\\S]*?>)");
        Matcher scriptMatcher = scripts.matcher(from);
        ArrayList<String> foundScripts = new ArrayList<String>();
        while (scriptMatcher.find()) {
            foundScripts.add(scriptMatcher.toMatchResult().group(0));
        }
        TranslatedString translated = new TranslatedString(from);
        Arrays.stream(HtmlLang.values()).sorted((one, two) -> Integer.compare(two.getIdentifier().length(), one.getIdentifier().length())).forEach((? super T lang) -> this.getNonDefault(lang).ifPresent(replacement -> translated.translate(lang.getDefault(), replacement.toString())));
        StringBuilder complete = new StringBuilder(translated.length());
        String[] parts = scripts.split(translated.toString());
        for (int i = 0; i < parts.length; ++i) {
            complete.append(parts[i]);
            if (i >= parts.length - 1) continue;
            complete.append(this.replaceLanguageInJavascript((String)foundScripts.get(i)));
        }
        return complete.toString();
    }

    public String replaceLanguageInJavascript(String from) {
        if (this.isEmpty()) {
            return from;
        }
        TranslatedString translated = new TranslatedString(from);
        Arrays.stream(JSLang.values()).sorted((one, two) -> Integer.compare(two.getIdentifier().length(), one.getIdentifier().length())).forEach((? super T lang) -> this.getNonDefault(lang).ifPresent(replacement -> translated.translate(lang.getDefault(), replacement.toString())));
        for (Lang extra : new Lang[]{HtmlLang.UNIT_NO_DATA, HtmlLang.TITLE_WORLD_PLAYTIME, HtmlLang.LABEL_OPERATOR, HtmlLang.LABEL_BANNED, HtmlLang.SIDE_SESSIONS, HtmlLang.LABEL_PLAYTIME, HtmlLang.LABEL_AFK_TIME, HtmlLang.LABEL_LONGEST_SESSION, HtmlLang.LABEL_SESSION_MEDIAN, HtmlLang.LABEL_PLAYER_KILLS, HtmlLang.LABEL_MOB_KILLS, HtmlLang.LABEL_DEATHS, HtmlLang.LABEL_PLAYERS_ONLINE, HtmlLang.LABEL_REGISTERED, HtmlLang.TITLE_SERVER, HtmlLang.TITLE_LENGTH, HtmlLang.TITLE_AVG_PING, HtmlLang.TITLE_BEST_PING, HtmlLang.TITLE_WORST_PING, HtmlLang.LABEL_FREE_DISK_SPACE, HtmlLang.LABEL_NEW_PLAYERS, HtmlLang.LABEL_UNIQUE_PLAYERS}) {
            this.getNonDefault(extra).ifPresent(replacement -> translated.translate(extra.getDefault(), replacement.toString()));
        }
        return translated.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Locale)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Locale locale = (Locale)o;
        return this.langCode == locale.langCode;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.langCode});
    }
}

