/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.locale;

import com.djrapitops.plan.settings.locale.LangCode;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.LocaleSystem;
import com.djrapitops.plan.settings.locale.Message;
import com.djrapitops.plan.settings.locale.lang.Lang;
import com.djrapitops.plan.storage.file.Resource;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LocaleFileReader {
    private List<String> lines;

    public LocaleFileReader(Resource resource) throws IOException {
        this.lines = resource.asLines();
    }

    public Locale load(LangCode code) {
        Locale locale = new Locale(code);
        Map<String, Lang> identifiers = LocaleSystem.getIdentifiers();
        this.lines.forEach(line -> {
            String identifier;
            Lang msg;
            String[] split = line.split(" \\|\\| ");
            if (split.length == 2 && (msg = (Lang)identifiers.get(identifier = split[0].trim())) != null) {
                locale.put(msg, new Message(split[1]));
            }
        });
        return locale;
    }
}

