/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.locale;

import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.LocaleSystem;
import com.djrapitops.plan.settings.locale.Message;
import com.djrapitops.plan.settings.locale.lang.Lang;
import com.djrapitops.plan.utilities.comparators.LocaleEntryComparator;
import com.djrapitops.plan.utilities.comparators.StringLengthComparator;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.stream.Collectors;

public class LocaleFileWriter {
    private final Locale locale;

    public LocaleFileWriter(Locale locale) {
        this.locale = locale;
    }

    public void writeToFile(File file) throws IOException {
        int length = LocaleSystem.getIdentifiers().keySet().stream().min(new StringLengthComparator()).map(String::length).orElse(0) + 2;
        this.addMissingLang();
        List<String> lines = this.createLines(length);
        this.write(file, lines);
    }

    private void write(File file, List<String> lines) throws IOException {
        if (!file.exists()) {
            Files.createFile(file.toPath(), new FileAttribute[0]);
        }
        Files.write(file.toPath(), lines, StandardCharsets.UTF_8, new OpenOption[0]);
    }

    private List<String> createLines(int length) {
        return this.locale.entrySet().stream().sorted(new LocaleEntryComparator()).map(entry -> {
            String value = entry.getValue() != null ? ((Message)entry.getValue()).toString() : ((Lang)entry.getKey()).getDefault();
            return this.getSpacedIdentifier(((Lang)entry.getKey()).getIdentifier(), length) + "|| " + value;
        }).collect(Collectors.toList());
    }

    private void addMissingLang() {
        for (Lang lang : LocaleSystem.getIdentifiers().values()) {
            if (this.locale.containsKey(lang)) continue;
            this.locale.put(lang, new Message(lang.getDefault()));
        }
    }

    private String getSpacedIdentifier(String identifier, int length) {
        StringBuilder b = new StringBuilder(identifier);
        while (b.length() < length) {
            b.append(" ");
        }
        return b.toString();
    }
}

