/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.locale;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.delivery.webserver.auth.FailReason;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.locale.LangCode;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.LocaleFileWriter;
import com.djrapitops.plan.settings.locale.lang.CmdHelpLang;
import com.djrapitops.plan.settings.locale.lang.CommandLang;
import com.djrapitops.plan.settings.locale.lang.DeepHelpLang;
import com.djrapitops.plan.settings.locale.lang.ErrorPageLang;
import com.djrapitops.plan.settings.locale.lang.GenericLang;
import com.djrapitops.plan.settings.locale.lang.HtmlLang;
import com.djrapitops.plan.settings.locale.lang.JSLang;
import com.djrapitops.plan.settings.locale.lang.Lang;
import com.djrapitops.plan.settings.locale.lang.ManageLang;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class LocaleSystem
implements SubSystem {
    private final PlanFiles files;
    private final PlanConfig config;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private final Locale locale;

    @Inject
    public LocaleSystem(PlanFiles files, PlanConfig config, PluginLogger logger, ErrorLogger errorLogger) {
        this.files = files;
        this.config = config;
        this.logger = logger;
        this.errorLogger = errorLogger;
        this.locale = new Locale();
    }

    public static Map<String, Lang> getIdentifiers() {
        Lang[][] lang = new Lang[][]{CommandLang.values(), CmdHelpLang.values(), DeepHelpLang.values(), PluginLang.values(), ManageLang.values(), GenericLang.values(), HtmlLang.values(), ErrorPageLang.values(), FailReason.values(), JSLang.values()};
        return Arrays.stream(lang).flatMap(Arrays::stream).collect(Collectors.toMap(Lang::getIdentifier, Function.identity()));
    }

    @Override
    public void enable() {
        File localeFile = this.files.getLocaleFile();
        if (this.config.isTrue(PluginSettings.WRITE_NEW_LOCALE)) {
            this.writeNewDefaultLocale(localeFile);
        }
        Optional<Locale> loaded = localeFile.exists() ? this.loadFromFile(localeFile) : this.loadSettingLocale();
        loaded.ifPresent(this.locale::loadFromAnotherLocale);
        LangCode langCode = this.locale.getLangCode();
        this.logger.info("Locale: '" + langCode.getName() + "' by " + langCode.getAuthors());
    }

    private void writeNewDefaultLocale(File localeFile) {
        try {
            Locale writing = this.loadSettingLocale().orElse(this.locale);
            if (localeFile.exists()) {
                writing.putAll(Locale.fromFile(localeFile));
            }
            new LocaleFileWriter(writing).writeToFile(localeFile);
        }
        catch (IOException | IllegalStateException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Fix write permissions to " + localeFile.getAbsolutePath()).build());
        }
        this.resetWriteConfigSetting();
    }

    private void resetWriteConfigSetting() {
        try {
            this.config.set(PluginSettings.WRITE_NEW_LOCALE, Boolean.valueOf(false));
            this.config.save();
        }
        catch (IOException | IllegalStateException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().whatToDo("Fix write permissions to " + this.config.getConfigFilePath()).build());
        }
    }

    private Optional<Locale> loadSettingLocale() {
        try {
            String setting = this.config.get(PluginSettings.LOCALE);
            if (!"default".equalsIgnoreCase(setting)) {
                return Optional.of(Locale.forLangCodeString(this.files, setting));
            }
        }
        catch (IOException e) {
            this.logger.warn("Failed to read locale from jar: " + this.config.get(PluginSettings.LOCALE) + ", " + e.toString());
            this.logger.warn("Using Default Locale as a fallback (EN)");
        }
        return Optional.empty();
    }

    private Optional<Locale> loadFromFile(File localeFile) {
        try {
            return Optional.of(Locale.fromFile(localeFile));
        }
        catch (IOException e) {
            this.logger.warn("Failed to read locale file at " + localeFile.getAbsolutePath() + ", " + e.toString());
            this.logger.warn("Using Default Locale as a fallback (EN)");
            return Optional.empty();
        }
    }

    @Override
    public void disable() {
    }

    public Locale getLocale() {
        return this.locale;
    }
}

