/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.locale;

import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import plan.org.apache.commons.lang3.StringUtils;

class TranslatedString {
    private static final Pattern LINK_MATCHER = Pattern.compile("http(s|)://[\\w.\\-_%/?$#@!()&=]+");
    private final List<TranslatedString> translating = new LinkedList<TranslatedString>();

    TranslatedString(String translating) {
        Matcher matcher = LINK_MATCHER.matcher(translating);
        int start = 0;
        while (matcher.find()) {
            String link = translating.substring(matcher.start(), matcher.end());
            String prev = translating.substring(start, matcher.start());
            if (!prev.isEmpty()) {
                this.translating.add(new Translatable(prev));
            }
            start = matcher.end();
            this.translating.add(new LockedString(link));
        }
        String remaining = translating.substring(start);
        if (!remaining.isEmpty()) {
            this.translating.add(new Translatable(remaining));
        }
    }

    TranslatedString() {
    }

    public void translate(String replace, String with) {
        for (TranslatedString sub : this.translating) {
            sub.translate(replace, with);
        }
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        this.toString(builder);
        return builder.toString();
    }

    public void toString(StringBuilder builder) {
        for (TranslatedString sub : this.translating) {
            sub.toString(builder);
        }
    }

    public int length() {
        int length = 0;
        for (TranslatedString sub : this.translating) {
            length += sub.length();
        }
        return length;
    }

    static class LockedString
    extends TranslatedString {
        final String text;

        LockedString(String text) {
            this.text = text;
        }

        @Override
        public void translate(String replace, String with) {
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append(this.text);
        }

        @Override
        public int length() {
            return this.text.length();
        }
    }

    static class Translatable
    extends TranslatedString {
        private String translating;

        Translatable(String translating) {
            this.translating = translating;
        }

        @Override
        public void translate(String replace, String with) {
            this.translating = StringUtils.replace(this.translating, replace, with);
        }

        @Override
        public void toString(StringBuilder builder) {
            builder.append(this.translating);
        }

        @Override
        public int length() {
            return this.translating.length();
        }
    }
}

