/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.network;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plan.settings.config.ConfigReader;
import com.djrapitops.plan.settings.config.ConfigWriter;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.PluginSettings;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.upkeep.FileWatcher;
import com.djrapitops.plan.settings.upkeep.WatchedFile;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.NewerConfigQuery;
import com.djrapitops.plan.storage.database.queries.objects.ServerQueries;
import com.djrapitops.plan.storage.database.transactions.StoreConfigTransaction;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import com.djrapitops.plugin.task.RunnableFactory;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NetworkSettingManager
implements SubSystem {
    private final PlanFiles files;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final RunnableFactory runnableFactory;
    private final PlanConfig config;
    private final PluginLogger logger;
    private final ErrorLogger errorLogger;
    private File serverSettingsFolder;
    private FileWatcher watcher;

    @Inject
    public NetworkSettingManager(PlanFiles files, PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, RunnableFactory runnableFactory, PluginLogger logger, ErrorLogger errorLogger) {
        this.files = files;
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.runnableFactory = runnableFactory;
        this.logger = logger;
        this.errorLogger = errorLogger;
    }

    @Override
    public void enable() throws EnableException {
        this.serverSettingsFolder = this.createServerSettingsFolder();
        this.watcher = this.prepareFileWatcher();
        this.watcher.start();
        this.logger.debug("Server Settings folder FileWatcher started.");
        this.scheduleDBCheckTask();
    }

    @Override
    public void disable() {
        if (this.watcher != null) {
            this.watcher.interrupt();
        }
    }

    public static UUID getServerUUIDFromFilename(File file) {
        String fileName = file.getName();
        String uuidString = fileName.substring(0, fileName.length() - 4);
        return UUID.fromString(uuidString);
    }

    private FileWatcher prepareFileWatcher() {
        FileWatcher fileWatcher = new FileWatcher(this.serverSettingsFolder, this.errorLogger);
        File[] files = this.getConfigFiles();
        if (files != null) {
            for (File file : files) {
                this.addFileToWatchList(fileWatcher, file);
            }
        }
        return fileWatcher;
    }

    public File[] getConfigFiles() {
        return this.serverSettingsFolder.listFiles((dir, name) -> name.endsWith(".yml"));
    }

    private void addFileToWatchList(FileWatcher fileWatcher, File file) {
        try {
            UUID serverUUID = NetworkSettingManager.getServerUUIDFromFilename(file);
            fileWatcher.addToWatchlist(new WatchedFile(file, () -> this.updateConfigInDB(file, serverUUID)));
        }
        catch (IllegalArgumentException | IndexOutOfBoundsException runtimeException) {
            // empty catch block
        }
    }

    private void scheduleDBCheckTask() {
        long checkPeriod = TimeAmount.toTicks(this.config.get(TimeSettings.CONFIG_UPDATE_INTERVAL), TimeUnit.MILLISECONDS);
        this.runnableFactory.create("Config Update DB Checker", new AbsRunnable(){

            @Override
            public void run() {
                NetworkSettingManager.this.updateConfigFromDBIfUpdated();
            }
        }).runTaskTimerAsynchronously(checkPeriod, checkPeriod);
    }

    private File createServerSettingsFolder() throws EnableException {
        try {
            File serverConfigFolder = this.files.getFileFromPluginFolder("serverConfiguration");
            Files.createDirectories(serverConfigFolder.toPath(), new FileAttribute[0]);
            return serverConfigFolder;
        }
        catch (IOException e) {
            throw new EnableException("Could not initialize NetworkSettingManager: " + e.getMessage(), e);
        }
    }

    private File getServerConfigFile(UUID serverUUID) {
        return new File(this.serverSettingsFolder, serverUUID + ".yml");
    }

    private void updateConfigFromDBIfUpdated() {
        Database database = this.dbSystem.getDatabase();
        Set<UUID> serverUUIDs = database.query(ServerQueries.fetchPlanServerInformation()).keySet();
        serverUUIDs.remove(this.serverInfo.getServerUUID());
        for (UUID serverUUID : serverUUIDs) {
            this.updateConfigFromDBIfUpdated(database, serverUUID);
        }
    }

    private void updateConfigFromDBIfUpdated(Database database, UUID serverUUID) {
        File configFile = this.getServerConfigFile(serverUUID);
        long lastModified = configFile.exists() ? configFile.lastModified() : -1L;
        Optional<Config> foundConfig = database.query(new NewerConfigQuery(serverUUID, lastModified));
        if (foundConfig.isPresent()) {
            try {
                Config writing = foundConfig.get();
                String serverName = writing.getNode(PluginSettings.SERVER_NAME.getPath()).map(ConfigNode::getString).orElse("Unknown");
                new ConfigWriter(configFile.toPath()).write(writing);
                this.logger.info("Config file for server '" + serverName + "' updated in /Plan/serverConfiguration");
                this.addFileToWatchList(this.watcher, configFile);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    public void updateConfigInDB(File file, UUID serverUUID) {
        if (!file.exists()) {
            return;
        }
        Database database = this.dbSystem.getDatabase();
        try (ConfigReader reader = new ConfigReader(file.toPath());){
            Config config = reader.read();
            database.executeTransaction(new StoreConfigTransaction(serverUUID, config, file.lastModified()));
            String serverName = config.getNode(PluginSettings.SERVER_NAME.getPath()).map(ConfigNode::getString).orElse("Unknown");
            this.logger.debug("Server config '" + serverName + "' in db now up to date.");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

