/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.network;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.TaskSystem;
import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ConfigReader;
import com.djrapitops.plan.settings.config.ConfigWriter;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.TimeSettings;
import com.djrapitops.plan.settings.upkeep.FileWatcher;
import com.djrapitops.plan.settings.upkeep.WatchedFile;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.queries.objects.NewerConfigQuery;
import com.djrapitops.plan.storage.database.transactions.StoreConfigTransaction;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.api.TimeAmount;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ServerSettingsManager
implements SubSystem {
    private final PlanFiles files;
    private final PlanConfig config;
    private final DBSystem dbSystem;
    private final ServerInfo serverInfo;
    private final TaskSystem taskSystem;
    private final ErrorLogger errorLogger;
    private final PluginLogger logger;
    private FileWatcher watcher;

    @Inject
    public ServerSettingsManager(PlanFiles files, PlanConfig config, DBSystem dbSystem, ServerInfo serverInfo, TaskSystem taskSystem, PluginLogger logger, ErrorLogger errorLogger) {
        this.files = files;
        this.config = config;
        this.dbSystem = dbSystem;
        this.serverInfo = serverInfo;
        this.taskSystem = taskSystem;
        this.logger = logger;
        this.errorLogger = errorLogger;
    }

    @Override
    public void enable() {
        this.watcher = this.prepareFileWatcher();
        this.watcher.start();
        this.logger.debug("Server Settings folder FileWatcher started.");
        this.scheduleDBCheckTask();
    }

    private FileWatcher prepareFileWatcher() {
        FileWatcher fileWatcher = new FileWatcher(this.files.getDataFolder(), this.errorLogger);
        File configFile = this.files.getConfigFile();
        fileWatcher.addToWatchlist(new WatchedFile(configFile, () -> this.updateConfigInDB(configFile)));
        return fileWatcher;
    }

    private void updateConfigInDB(File file) {
        if (!file.exists()) {
            return;
        }
        Database database = this.dbSystem.getDatabase();
        Optional<UUID> serverUUID = this.serverInfo.getServerUUIDSafe();
        if (!serverUUID.isPresent()) {
            return;
        }
        try (ConfigReader reader = new ConfigReader(file.toPath());){
            Config read = reader.read();
            database.executeTransaction(new StoreConfigTransaction(serverUUID.get(), read, file.lastModified()));
            this.logger.debug("Server config saved to database.");
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private void scheduleDBCheckTask() {
        long checkPeriod = TimeAmount.toTicks(this.config.get(TimeSettings.CONFIG_UPDATE_INTERVAL), TimeUnit.MILLISECONDS);
        this.taskSystem.registerTask("Config Update DB Checker", new AbsRunnable(){

            @Override
            public void run() {
                ServerSettingsManager.this.checkDBForNewConfigSettings(ServerSettingsManager.this.dbSystem.getDatabase());
            }
        }).runTaskTimerAsynchronously(checkPeriod, checkPeriod);
    }

    private void checkDBForNewConfigSettings(Database database) {
        File configFile = this.files.getConfigFile();
        long lastModified = configFile.exists() ? configFile.lastModified() : -1L;
        Optional<UUID> serverUUID = this.serverInfo.getServerUUIDSafe();
        if (!serverUUID.isPresent()) {
            return;
        }
        Optional<Config> foundConfig = database.query(new NewerConfigQuery(serverUUID.get(), lastModified));
        if (foundConfig.isPresent()) {
            try {
                new ConfigWriter(configFile.toPath()).write(foundConfig.get());
                this.logger.info("The Config was updated to match one on the Proxy. Reload for changes to take effect.");
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }

    @Override
    public void disable() {
        if (this.watcher != null) {
            this.watcher.interrupt();
        }
    }
}

