/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.theme;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.theme.ThemeConfig;
import com.djrapitops.plan.settings.theme.ThemeVal;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;
import plan.org.apache.commons.lang3.StringUtils;

@Singleton
public class Theme
implements SubSystem {
    private final PlanFiles files;
    private final PlanConfig config;
    private final PluginLogger logger;
    private ThemeConfig themeConfig;

    @Inject
    public Theme(PlanFiles files, PlanConfig config, PluginLogger logger) {
        this.files = files;
        this.config = config;
        this.logger = logger;
    }

    public String getValue(ThemeVal variable) {
        try {
            return this.getThemeValue(variable);
        }
        catch (IllegalStateException | NullPointerException e) {
            return variable.getDefaultValue();
        }
    }

    public String[] getPieColors(ThemeVal variable) {
        return (String[])Arrays.stream(StringUtils.split(this.getValue(variable), ',')).map(color -> StringUtils.remove(StringUtils.trim(color), '\"')).toArray(String[]::new);
    }

    @Override
    public void enable() throws EnableException {
        try {
            this.themeConfig = new ThemeConfig(this.files, this.config, this.logger);
            this.themeConfig.save();
        }
        catch (IOException e) {
            throw new EnableException("theme.yml could not be saved.", e);
        }
    }

    @Override
    public void disable() {
    }

    private String getColor(ThemeVal variable) {
        String path = variable.getThemePath();
        try {
            return this.themeConfig.getString(path);
        }
        catch (Exception | NoSuchFieldError e) {
            this.logger.error("Something went wrong with getting variable " + variable.name() + " for: " + path);
            return variable.getDefaultValue();
        }
    }

    public String replaceThemeColors(String resourceString) {
        return this.replaceVariables(resourceString, ThemeVal.RED, ThemeVal.PINK, ThemeVal.PURPLE, ThemeVal.DEEP_PURPLE, ThemeVal.INDIGO, ThemeVal.BLUE, ThemeVal.LIGHT_BLUE, ThemeVal.CYAN, ThemeVal.TEAL, ThemeVal.GREEN, ThemeVal.LIGHT_GREEN, ThemeVal.LIME, ThemeVal.YELLOW, ThemeVal.AMBER, ThemeVal.ORANGE, ThemeVal.DEEP_ORANGE, ThemeVal.BROWN, ThemeVal.GREY, ThemeVal.BLUE_GREY, ThemeVal.BLACK, ThemeVal.WHITE, ThemeVal.GRAPH_PUNCHCARD, ThemeVal.GRAPH_PLAYERS_ONLINE, ThemeVal.GRAPH_TPS_HIGH, ThemeVal.GRAPH_TPS_MED, ThemeVal.GRAPH_TPS_LOW, ThemeVal.GRAPH_CPU, ThemeVal.GRAPH_RAM, ThemeVal.GRAPH_CHUNKS, ThemeVal.GRAPH_ENTITIES, ThemeVal.GRAPH_WORLD_PIE, ThemeVal.FONT_STYLESHEET, ThemeVal.FONT_FAMILY);
    }

    private String replaceVariables(String resourceString, ThemeVal ... themeVariables) {
        ArrayList<String> replace = new ArrayList<String>();
        ArrayList<String> with = new ArrayList<String>();
        for (ThemeVal variable : themeVariables) {
            String value = this.getColor(variable);
            String defaultValue = variable.getDefaultValue();
            if (defaultValue.equals(value)) continue;
            replace.add(defaultValue);
            with.add(value);
        }
        replace.add("${defaultTheme}");
        with.add(this.getValue(ThemeVal.THEME_DEFAULT));
        return StringUtils.replaceEach(resourceString, replace.toArray(new String[0]), with.toArray(new String[0]));
    }

    private String getThemeValue(ThemeVal color) {
        return this.themeConfig.getString(color.getThemePath());
    }
}

