/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.theme;

import com.djrapitops.plan.settings.config.Config;
import com.djrapitops.plan.settings.config.ConfigNode;
import com.djrapitops.plan.settings.config.ConfigReader;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.settings.config.paths.DisplaySettings;
import com.djrapitops.plan.settings.theme.ThemeVal;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.File;
import java.io.IOException;

public class ThemeConfig
extends Config {
    public ThemeConfig(PlanFiles files, PlanConfig config, PluginLogger logger) {
        this(ThemeConfig.getConfigFile(files), ThemeConfig.getDefaults(files, config, logger));
    }

    private ThemeConfig(File configFile, ConfigNode defaults) {
        super(configFile, defaults);
        if (defaults.isLeafNode()) {
            ConfigNode util = new ConfigNode("", null, "");
            for (ThemeVal themeVal : ThemeVal.values()) {
                util.set(themeVal.getThemePath(), themeVal.getDefaultValue());
            }
            this.copyMissing(util);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ConfigNode getDefaults(PlanFiles files, PlanConfig config, PluginLogger logger) {
        String fileName = config.get(DisplaySettings.THEME);
        String fileLocation = ThemeConfig.getFileLocation(fileName);
        try (ConfigReader reader = new ConfigReader(files.getResourceFromJar(fileLocation).asInputStream());){
            Config config2 = reader.read();
            return config2;
        }
        catch (IOException e) {
            logger.error("Could not find theme " + fileLocation + ". Attempting to use default.");
            return new ConfigNode(null, null, null);
        }
    }

    private static String getFileLocation(String fileName) {
        switch (fileName.toLowerCase()) {
            case "soft": 
            case "soften": {
                return "themes/soft.yml";
            }
            case "mute": 
            case "lowsaturation": {
                return "themes/mute.yml";
            }
            case "pastel": 
            case "bright": 
            case "harsh": 
            case "saturated": 
            case "high": {
                return "themes/pastel.yml";
            }
            case "sepia": 
            case "brown": {
                return "themes/sepia.yml";
            }
            case "grey": 
            case "gray": 
            case "greyscale": 
            case "grayscale": {
                return "themes/greyscale.yml";
            }
        }
        return "themes/theme.yml";
    }

    private static File getConfigFile(PlanFiles files) {
        return files.getFileFromPluginFolder("theme.yml");
    }
}

