/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.upkeep;

import com.djrapitops.plan.identification.ServerInfo;
import com.djrapitops.plan.settings.config.PlanConfig;
import com.djrapitops.plan.storage.database.DBSystem;
import com.djrapitops.plan.storage.database.transactions.StoreConfigTransaction;
import com.djrapitops.plan.storage.file.PlanFiles;
import com.djrapitops.plugin.logging.console.PluginLogger;
import com.djrapitops.plugin.task.AbsRunnable;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class ConfigStoreTask
extends AbsRunnable {
    private final PlanFiles files;
    private final PlanConfig config;
    private final ServerInfo serverInfo;
    private final DBSystem dbSystem;
    private final PluginLogger logger;

    @Inject
    public ConfigStoreTask(PlanFiles files, PlanConfig config, ServerInfo serverInfo, DBSystem dbSystem, PluginLogger logger) {
        this.files = files;
        this.config = config;
        this.serverInfo = serverInfo;
        this.dbSystem = dbSystem;
        this.logger = logger;
    }

    @Override
    public void run() {
        long lastModified = this.files.getConfigFile().lastModified();
        this.dbSystem.getDatabase().executeTransaction(new StoreConfigTransaction(this.serverInfo.getServerUUID(), this.config, lastModified));
        this.logger.debug("Config Store Task - Config in db now up to date.");
        this.cancel();
    }
}

