/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.upkeep;

import com.djrapitops.plan.settings.upkeep.WatchedFile;
import com.djrapitops.plan.utilities.logging.ErrorContext;
import com.djrapitops.plan.utilities.logging.ErrorLogger;
import com.djrapitops.plugin.logging.L;
import com.djrapitops.plugin.utilities.Verify;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class FileWatcher
extends Thread {
    private final ErrorLogger errorLogger;
    private volatile boolean running;
    private final Path watchedPath;
    private final Set<WatchedFile> watchedFiles;

    public FileWatcher(File folder, ErrorLogger errorLogger) {
        this(folder.toPath(), errorLogger);
    }

    public FileWatcher(Path watchedPath, ErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
        this.running = false;
        this.watchedFiles = Collections.newSetFromMap(new ConcurrentHashMap());
        Verify.isTrue(watchedPath.toFile().isDirectory(), () -> new IllegalArgumentException("Given File " + watchedPath.toString() + " was not a folder."));
        this.watchedPath = watchedPath;
    }

    public void addToWatchlist(WatchedFile watchedFile) {
        this.watchedFiles.remove(watchedFile);
        this.watchedFiles.add(watchedFile);
    }

    @Override
    public void run() {
        this.running = true;
        try (WatchService watcher = FileSystems.getDefault().newWatchService();){
            this.watchedPath.register(watcher, StandardWatchEventKinds.ENTRY_MODIFY);
            this.runLoop(watcher);
        }
        catch (IOException e) {
            this.errorLogger.log(L.ERROR, e, ErrorContext.builder().build());
            this.interrupt();
        }
        catch (InterruptedException e) {
            this.interrupt();
        }
    }

    private void runLoop(WatchService watcher) throws InterruptedException {
        while (this.running) {
            WatchKey key = watcher.take();
            if (key == null) {
                Thread.yield();
                continue;
            }
            this.pollEvents(key);
        }
    }

    private void pollEvents(WatchKey key) {
        for (WatchEvent<?> event : key.pollEvents()) {
            this.handleEvent(event);
            if (key.reset()) continue;
            break;
        }
    }

    private void handleEvent(WatchEvent<?> event) {
        if (event.kind() != StandardWatchEventKinds.ENTRY_MODIFY) {
            Thread.yield();
        } else {
            Path modifiedFile = (Path)event.context();
            this.actOnModification(this.watchedPath.resolve(modifiedFile));
        }
    }

    private void actOnModification(Path modifiedFile) {
        for (WatchedFile watchedFile : this.watchedFiles) {
            watchedFile.modified(modifiedFile);
        }
    }

    @Override
    public void interrupt() {
        this.running = false;
        super.interrupt();
    }

    public boolean isRunning() {
        return this.running;
    }
}

