/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.upkeep;

import com.djrapitops.plan.settings.network.NetworkSettingManager;
import com.djrapitops.plugin.task.AbsRunnable;
import java.io.File;
import java.util.UUID;
import plan.javax.inject.Inject;
import plan.javax.inject.Singleton;

@Singleton
public class NetworkConfigStoreTask
extends AbsRunnable {
    private final NetworkSettingManager networkSettingManager;

    @Inject
    public NetworkConfigStoreTask(NetworkSettingManager networkSettingManager) {
        this.networkSettingManager = networkSettingManager;
    }

    @Override
    public void run() {
        this.updateDBConfigs();
        this.cancel();
    }

    private void updateDBConfigs() {
        File[] configFiles;
        for (File configFile : configFiles = this.networkSettingManager.getConfigFiles()) {
            UUID serverUUID = NetworkSettingManager.getServerUUIDFromFilename(configFile);
            this.networkSettingManager.updateConfigInDB(configFile, serverUUID);
        }
    }
}

