/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.settings.upkeep;

import com.djrapitops.plan.utilities.java.VoidFunction;
import java.io.File;
import java.nio.file.Path;
import java.util.Objects;

public class WatchedFile {
    private final Path watchedPath;
    private final VoidFunction onChange;

    public WatchedFile(File file, VoidFunction onChange) {
        this(file.toPath(), onChange);
    }

    public WatchedFile(Path path, VoidFunction onChange) {
        this.watchedPath = path;
        this.onChange = onChange;
    }

    public void modified(Path modifiedPath) {
        if (this.watchedPath.equals(modifiedPath)) {
            this.onChange.apply();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WatchedFile that = (WatchedFile)o;
        return Objects.equals(this.watchedPath, that.watchedPath);
    }

    public int hashCode() {
        return Objects.hash(this.watchedPath);
    }
}

