/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database;

import com.djrapitops.plan.exceptions.database.DBOpException;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.transactions.Transaction;
import com.djrapitops.plan.storage.database.transactions.init.OperationCriticalTransaction;

public class DBAccessLock {
    private final Database database;
    private final Object lockObject;

    public DBAccessLock(Database database) {
        this.database = database;
        this.lockObject = new Object();
    }

    public void checkAccess() {
        this.checkAccess(false);
    }

    public void checkAccess(Transaction transaction) {
        this.checkAccess(transaction instanceof OperationCriticalTransaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void checkAccess(boolean isOperationCriticalTransaction) {
        if (isOperationCriticalTransaction) {
            return;
        }
        try {
            while (this.database.getState() != Database.State.OPEN && this.database.getState() != Database.State.CLOSING) {
                Object object = this.lockObject;
                synchronized (object) {
                    this.lockObject.wait();
                    if (this.database.getState() == Database.State.CLOSED) {
                        throw new DBOpException("Database failed to open, Query has failed. (This exception is necessary to not keep query threads waiting)");
                    }
                }
            }
            return;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operabilityChanged() {
        Object object = this.lockObject;
        synchronized (object) {
            this.lockObject.notifyAll();
        }
    }
}

