/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database;

import com.djrapitops.plan.SubSystem;
import com.djrapitops.plan.exceptions.EnableException;
import com.djrapitops.plan.exceptions.database.DBInitException;
import com.djrapitops.plan.settings.locale.Locale;
import com.djrapitops.plan.settings.locale.lang.PluginLang;
import com.djrapitops.plan.storage.database.DBType;
import com.djrapitops.plan.storage.database.Database;
import com.djrapitops.plan.storage.database.H2DB;
import com.djrapitops.plan.storage.database.SQLiteDB;
import com.djrapitops.plugin.logging.console.PluginLogger;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import plan.javax.inject.Singleton;

@Singleton
public abstract class DBSystem
implements SubSystem {
    protected final Locale locale;
    private final SQLiteDB.Factory sqLiteFactory;
    private final H2DB.Factory h2Factory;
    protected final PluginLogger logger;
    protected Database db;
    protected final Set<Database> databases;

    public DBSystem(Locale locale, SQLiteDB.Factory sqLiteDB, H2DB.Factory h2Factory, PluginLogger logger) {
        this.locale = locale;
        this.sqLiteFactory = sqLiteDB;
        this.h2Factory = h2Factory;
        this.logger = logger;
        this.databases = new HashSet<Database>();
    }

    public Database getActiveDatabaseByName(String dbName) {
        return DBType.getForName(dbName).map(this::getActiveDatabaseByType).orElseThrow(() -> new IllegalArgumentException(this.locale.getString(PluginLang.ENABLE_FAIL_WRONG_DB, new Serializable[]{dbName})));
    }

    public Database getActiveDatabaseByType(DBType type) {
        for (Database database : this.getDatabases()) {
            if (database.getType() != type) continue;
            return database;
        }
        throw new IllegalArgumentException(this.locale.getString(PluginLang.ENABLE_FAIL_WRONG_DB, new Serializable[]{type != null ? type.getName() : "null"}));
    }

    public Set<Database> getDatabases() {
        return this.databases;
    }

    @Override
    public void disable() {
        if (this.db != null) {
            this.db.close();
        }
    }

    public Database getDatabase() {
        return this.db;
    }

    @Override
    public void enable() throws EnableException {
        try {
            this.db.init();
            this.logger.info(this.locale.getString(PluginLang.ENABLED_DATABASE, new Serializable[]{this.db.getType().getName()}));
        }
        catch (DBInitException e) {
            Throwable cause = e.getCause();
            String message = cause == null ? e.getMessage() : cause.getMessage();
            throw new EnableException(this.db.getType().getName() + " init failure: " + message, cause);
        }
    }

    public void setActiveDatabase(Database db) {
        this.db.close();
        this.db = db;
    }

    public SQLiteDB.Factory getSqLiteFactory() {
        return this.sqLiteFactory;
    }

    public H2DB.Factory getH2Factory() {
        return this.h2Factory;
    }
}

