/*
 * Decompiled with CFR 0.152.
 */
package com.djrapitops.plan.storage.database;

import com.djrapitops.plan.storage.database.sql.building.Sql;
import java.util.Optional;

public enum DBType {
    MYSQL("MySQL", true, new Sql.MySQL()),
    SQLITE("SQLite", false, new Sql.SQLite()),
    H2("H2", true, new Sql.H2());

    private final String name;
    private final String configName;
    private final boolean supportingMySQLQueries;
    private final Sql sql;

    private DBType(String name, boolean supportingMySQLQueries, Sql sql) {
        this.name = name;
        this.configName = name.toLowerCase().trim();
        this.supportingMySQLQueries = supportingMySQLQueries;
        this.sql = sql;
    }

    public String getName() {
        return this.name;
    }

    public String getConfigName() {
        return this.configName;
    }

    public boolean supportsMySQLQueries() {
        return this.supportingMySQLQueries;
    }

    public static Optional<DBType> getForName(String name) {
        for (DBType dbType : DBType.values()) {
            if (!dbType.getName().equalsIgnoreCase(name)) continue;
            return Optional.of(dbType);
        }
        return Optional.empty();
    }

    public static boolean exists(String name) {
        for (DBType dbType : DBType.values()) {
            if (!dbType.getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return false;
    }

    public Sql getSql() {
        return this.sql;
    }
}

